/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.CompactionAppendMsgCallback;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageLock;
import org.apache.rocketmq.store.PutMessageReentrantLock;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageSpinLock;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.StoreUtil;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.kv.CompactionPositionMgr;
import org.apache.rocketmq.store.kv.CompactionStore;
import org.apache.rocketmq.store.kv.MessageFetcher;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.queue.SparseConsumeQueue;

public class CompactionLog {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final int END_FILE_MIN_BLANK_LENGTH = 8;
    private static final int MAX_PULL_MSG_SIZE = 0x8000000;
    public static final String COMPACTING_SUB_FOLDER = "compacting";
    public static final String REPLICATING_SUB_FOLDER = "replicating";
    private final int compactionLogMappedFileSize;
    private final int compactionCqMappedFileSize;
    private final String compactionLogFilePath;
    private final String compactionCqFilePath;
    private final MessageStore defaultMessageStore;
    private final CompactionStore compactionStore;
    private final MessageStoreConfig messageStoreConfig;
    private final CompactionAppendMsgCallback endMsgCallback;
    private final String topic;
    private final int queueId;
    private final int offsetMapMemorySize;
    private final PutMessageLock putMessageLock;
    private final PutMessageLock readMessageLock;
    private TopicPartitionLog current;
    private TopicPartitionLog compacting;
    private TopicPartitionLog replicating;
    private final CompactionPositionMgr positionMgr;
    private final AtomicReference<State> state;

    public CompactionLog(MessageStore messageStore, CompactionStore compactionStore, String topic, int queueId) throws IOException {
        this.topic = topic;
        this.queueId = queueId;
        this.defaultMessageStore = messageStore;
        this.compactionStore = compactionStore;
        this.messageStoreConfig = messageStore.getMessageStoreConfig();
        this.offsetMapMemorySize = compactionStore.getOffsetMapSize();
        this.compactionCqMappedFileSize = this.messageStoreConfig.getCompactionCqMappedFileSize() / 46 * 46;
        this.compactionLogMappedFileSize = this.getCompactionLogSize(this.compactionCqMappedFileSize, this.messageStoreConfig.getCompactionMappedFileSize());
        this.compactionLogFilePath = Paths.get(compactionStore.getCompactionLogPath(), topic, String.valueOf(queueId)).toString();
        this.compactionCqFilePath = compactionStore.getCompactionCqPath();
        this.positionMgr = compactionStore.getPositionMgr();
        this.putMessageLock = messageStore.getMessageStoreConfig().isUseReentrantLockWhenPutMessage() ? new PutMessageReentrantLock() : new PutMessageSpinLock();
        this.readMessageLock = messageStore.getMessageStoreConfig().isUseReentrantLockWhenPutMessage() ? new PutMessageReentrantLock() : new PutMessageSpinLock();
        this.endMsgCallback = new CompactionAppendEndMsgCallback();
        this.state = new AtomicReference<State>(State.INITIALIZING);
        log.info("CompactionLog {}:{} init completed.", (Object)topic, (Object)queueId);
    }

    private int getCompactionLogSize(int cqSize, int origLogSize) {
        int n = origLogSize / cqSize;
        if (n < 5) {
            return cqSize * 5;
        }
        int m = origLogSize % cqSize;
        if (m > 0 && m < cqSize >> 1) {
            return n * cqSize;
        }
        return (n + 1) * cqSize;
    }

    public void load(boolean exitOk) throws IOException, RuntimeException {
        this.initLogAndCq(exitOk);
        if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE && this.getLog().isMappedFilesEmpty()) {
            log.info("{}:{} load compactionLog from remote master", (Object)this.topic, (Object)this.queueId);
            this.loadFromRemoteAsync();
        } else {
            this.state.compareAndSet(State.INITIALIZING, State.NORMAL);
        }
    }

    private void initLogAndCq(boolean exitOk) throws IOException, RuntimeException {
        this.current = new TopicPartitionLog(this);
        this.current.init(exitOk);
    }

    private boolean putMessageFromRemote(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        while (byteBuffer.hasRemaining()) {
            int mark = byteBuffer.position();
            ByteBuffer bb = byteBuffer.slice();
            int size = bb.getInt();
            if (size < 0 || size > byteBuffer.capacity()) break;
            bb.limit(size);
            bb.rewind();
            MessageExt messageExt = MessageDecoder.decode((ByteBuffer)bb, (boolean)false, (boolean)false);
            long messageOffset = messageExt.getQueueOffset();
            long minOffsetInQueue = this.getCQ().getMinOffsetInQueue();
            if (!this.getLog().isMappedFilesEmpty() && messageOffset >= minOffsetInQueue) {
                log.info("{}:{} message offset {} >= minOffsetInQueue {}, stop pull...", new Object[]{this.topic, this.queueId, messageOffset, minOffsetInQueue});
                return false;
            }
            this.asyncPutMessage(bb, messageExt, this.replicating);
            byteBuffer.position(mark + size);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMessageFromMaster() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.compactionStore.getMasterAddr())) {
            this.compactionStore.getCompactionSchedule().schedule(() -> {
                try {
                    this.pullMessageFromMaster();
                }
                catch (Exception e) {
                    log.error("pullMessageFromMaster exception: ", (Throwable)e);
                }
            }, 5L, TimeUnit.SECONDS);
            return;
        }
        this.replicating = new TopicPartitionLog(this, REPLICATING_SUB_FOLDER);
        try (MessageFetcher messageFetcher = new MessageFetcher();){
            messageFetcher.pullMessageFromMaster(this.topic, this.queueId, this.getCQ().getMinOffsetInQueue(), this.compactionStore.getMasterAddr(), (currOffset, response) -> {
                if (currOffset < 0L) {
                    log.info("{}:{} current offset {}, stop pull...", new Object[]{this.topic, this.queueId, currOffset});
                    return false;
                }
                return this.putMessageFromRemote(response.getBody());
            });
        }
        if (this.getLog().isMappedFilesEmpty()) {
            this.replaceFiles(this.getLog().getMappedFiles(), this.current, this.replicating);
        } else if (this.replicating.getLog().isMappedFilesEmpty()) {
            log.info("replicating message is empty");
        } else {
            ArrayList newFiles = Lists.newArrayList();
            ArrayList toCompactFiles = Lists.newArrayList(this.replicating.getLog().getMappedFiles());
            this.putMessageLock.lock();
            try {
                newFiles = Lists.newArrayList(this.getLog().getMappedFiles());
                toCompactFiles.addAll(newFiles);
                this.current.roll(toCompactFiles.size() * this.compactionLogMappedFileSize);
            }
            catch (Throwable e) {
                log.error("roll log and cq exception: ", e);
            }
            finally {
                this.putMessageLock.unlock();
            }
            try {
                this.compactAndReplace(new ProcessFileList(toCompactFiles, toCompactFiles));
            }
            catch (Throwable e) {
                log.error("do merge replicating and current exception: ", e);
            }
        }
        this.replicating.clean(false, true);
        this.state.compareAndSet(State.INITIALIZING, State.NORMAL);
    }

    private void loadFromRemoteAsync() {
        this.compactionStore.getCompactionSchedule().submit(() -> {
            try {
                this.pullMessageFromMaster();
            }
            catch (Exception e) {
                log.error("fetch message from master exception: ", (Throwable)e);
            }
        });
    }

    private long nextOffsetCorrection(long oldOffset, long newOffset) {
        long nextOffset = oldOffset;
        if (this.messageStoreConfig.getBrokerRole() != BrokerRole.SLAVE || this.messageStoreConfig.isOffsetCheckInSlave()) {
            nextOffset = newOffset;
        }
        return nextOffset;
    }

    private boolean checkInDiskByCommitOffset(long offsetPy, long maxOffsetPy) {
        long memory = (long)((double)StoreUtil.TOTAL_PHYSICAL_MEMORY_SIZE * ((double)this.messageStoreConfig.getAccessMessageInMemoryMaxRatio() / 100.0));
        return maxOffsetPy - offsetPy > memory;
    }

    private boolean isTheBatchFull(int sizePy, int unitBatchNum, int maxMsgNums, long maxMsgSize, int bufferTotal, int messageTotal, boolean isInDisk) {
        if (0 == bufferTotal || 0 == messageTotal) {
            return false;
        }
        if (messageTotal + unitBatchNum > maxMsgNums) {
            return true;
        }
        if ((long)(bufferTotal + sizePy) > maxMsgSize) {
            return true;
        }
        if (isInDisk) {
            if (bufferTotal + sizePy > this.messageStoreConfig.getMaxTransferBytesOnMessageInDisk()) {
                return true;
            }
            if (messageTotal > this.messageStoreConfig.getMaxTransferCountOnMessageInDisk() - 1) {
                return true;
            }
        } else {
            if (bufferTotal + sizePy > this.messageStoreConfig.getMaxTransferBytesOnMessageInMemory()) {
                return true;
            }
            if (messageTotal > this.messageStoreConfig.getMaxTransferCountOnMessageInMemory() - 1) {
                return true;
            }
        }
        return false;
    }

    public long rollNextFile(long offset) {
        return offset + (long)this.compactionLogMappedFileSize - offset % (long)this.compactionLogMappedFileSize;
    }

    boolean shouldRetainMsg(MessageExt msgExt, OffsetMap map) throws DigestException {
        if (msgExt.getQueueOffset() > map.getLastOffset()) {
            return true;
        }
        String key = msgExt.getKeys();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            boolean keyNotExistOrOffsetBigger = msgExt.getQueueOffset() >= map.get(key);
            boolean hasBody = ArrayUtils.isNotEmpty((byte[])msgExt.getBody());
            return keyNotExistOrOffsetBigger && hasBody;
        }
        log.error("message has no keys");
        return false;
    }

    public void checkAndPutMessage(SelectMappedBufferResult selectMappedBufferResult, MessageExt msgExt, OffsetMap offsetMap, TopicPartitionLog tpLog) throws DigestException {
        if (this.shouldRetainMsg(msgExt, offsetMap)) {
            this.asyncPutMessage(selectMappedBufferResult.getByteBuffer(), msgExt, tpLog);
        }
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(SelectMappedBufferResult selectMappedBufferResult) {
        return this.asyncPutMessage(selectMappedBufferResult, this.current);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(SelectMappedBufferResult selectMappedBufferResult, TopicPartitionLog tpLog) {
        MessageExt msgExt = MessageDecoder.decode((ByteBuffer)selectMappedBufferResult.getByteBuffer(), (boolean)false, (boolean)false);
        return this.asyncPutMessage(selectMappedBufferResult.getByteBuffer(), msgExt, tpLog);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(ByteBuffer msgBuffer, MessageExt msgExt, TopicPartitionLog tpLog) {
        return this.asyncPutMessage(msgBuffer, msgExt.getTopic(), msgExt.getQueueId(), msgExt.getQueueOffset(), msgExt.getMsgId(), msgExt.getKeys(), MessageExtBrokerInner.tagsString2tagsCode((String)msgExt.getTags()), msgExt.getStoreTimestamp(), tpLog);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(ByteBuffer msgBuffer, DispatchRequest dispatchRequest) {
        return this.asyncPutMessage(msgBuffer, dispatchRequest.getTopic(), dispatchRequest.getQueueId(), dispatchRequest.getConsumeQueueOffset(), dispatchRequest.getUniqKey(), dispatchRequest.getKeys(), dispatchRequest.getTagsCode(), dispatchRequest.getStoreTimestamp(), this.current);
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(ByteBuffer msgBuffer, DispatchRequest dispatchRequest, TopicPartitionLog tpLog) {
        return this.asyncPutMessage(msgBuffer, dispatchRequest.getTopic(), dispatchRequest.getQueueId(), dispatchRequest.getConsumeQueueOffset(), dispatchRequest.getUniqKey(), dispatchRequest.getKeys(), dispatchRequest.getTagsCode(), dispatchRequest.getStoreTimestamp(), tpLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PutMessageResult> asyncPutMessage(ByteBuffer msgBuffer, String topic, int queueId, long queueOffset, String msgId, String keys, long tagsCode, long storeTimestamp, TopicPartitionLog tpLog) {
        if (tpLog.getCQ().getMaxOffsetInQueue() - 1L >= queueOffset) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        if (StringUtils.isBlank((CharSequence)keys)) {
            log.warn("message {}-{}:{} have no key, will not put in compaction log", new Object[]{topic, queueId, msgId});
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        this.putMessageLock.lock();
        try {
            long beginTime = System.nanoTime();
            if (tpLog.isEmptyOrCurrentFileFull()) {
                try {
                    tpLog.roll();
                }
                catch (IOException e) {
                    log.error("create mapped file or consumerQueue exception: ", (Throwable)e);
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, null));
                    this.putMessageLock.unlock();
                    return completableFuture;
                }
            }
            MappedFile mappedFile = tpLog.getLog().getLastMappedFile();
            CompactionAppendMessageCallback callback = new CompactionAppendMessageCallback(topic, queueId, tagsCode, storeTimestamp, tpLog.getCQ());
            AppendMessageResult result = mappedFile.appendMessage(msgBuffer, callback);
            switch (result.getStatus()) {
                case PUT_OK: {
                    break;
                }
                case END_OF_FILE: {
                    try {
                        tpLog.roll();
                    }
                    catch (IOException e) {
                        log.error("create mapped file2 error, topic: {}, msgId: {}", (Object)topic, (Object)msgId);
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, result));
                        this.putMessageLock.unlock();
                        return completableFuture;
                    }
                    mappedFile = tpLog.getLog().getLastMappedFile();
                    result = mappedFile.appendMessage(msgBuffer, callback);
                    break;
                }
                default: {
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                    return completableFuture;
                }
            }
            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.PUT_OK, result));
            return completableFuture;
        }
        finally {
            this.putMessageLock.unlock();
        }
    }

    private SelectMappedBufferResult getMessage(long offset, int size) {
        MappedFile mappedFile = this.getLog().findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)this.compactionLogMappedFileSize);
            return mappedFile.selectMappedBuffer(pos, size);
        }
        return null;
    }

    private boolean validateCqUnit(CqUnit cqUnit) {
        return cqUnit.getPos() >= 0L && cqUnit.getSize() > 0 && cqUnit.getQueueOffset() >= 0L && cqUnit.getBatchNum() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, int maxTotalMsgSize) {
        this.readMessageLock.lock();
        try {
            GetMessageStatus status;
            long beginTime = System.nanoTime();
            long nextBeginOffset = offset;
            long minOffset = 0L;
            long maxOffset = 0L;
            GetMessageResult getResult = new GetMessageResult();
            long maxOffsetPy = this.getLog().getMaxOffset();
            SparseConsumeQueue consumeQueue = this.getCQ();
            if (consumeQueue != null) {
                minOffset = consumeQueue.getMinOffsetInQueue();
                maxOffset = consumeQueue.getMaxOffsetInQueue();
                if (maxOffset == 0L) {
                    status = GetMessageStatus.NO_MESSAGE_IN_QUEUE;
                    nextBeginOffset = this.nextOffsetCorrection(offset, 0L);
                } else if (offset == maxOffset) {
                    status = GetMessageStatus.OFFSET_OVERFLOW_ONE;
                    nextBeginOffset = this.nextOffsetCorrection(offset, offset);
                } else if (offset > maxOffset) {
                    status = GetMessageStatus.OFFSET_OVERFLOW_BADLY;
                    nextBeginOffset = 0L == minOffset ? this.nextOffsetCorrection(offset, minOffset) : this.nextOffsetCorrection(offset, maxOffset);
                } else {
                    long memory;
                    long diff;
                    long maxPullSize = Math.max(maxTotalMsgSize, 100);
                    if (maxPullSize > 0x8000000L) {
                        log.warn("The max pull size is too large maxPullSize={} topic={} queueId={}", new Object[]{maxPullSize, topic, queueId});
                        maxPullSize = 0x8000000L;
                    }
                    status = GetMessageStatus.NO_MATCHED_MESSAGE;
                    long maxPhyOffsetPulling = 0L;
                    int cqFileNum = 0;
                    block6: while (getResult.getBufferTotalSize() <= 0 && nextBeginOffset < maxOffset && cqFileNum++ < this.messageStoreConfig.getTravelCqFileNumWhenGetMessage()) {
                        ReferredIterator<CqUnit> bufferConsumeQueue = consumeQueue.iterateFromOrNext(nextBeginOffset);
                        if (bufferConsumeQueue == null) {
                            status = GetMessageStatus.OFFSET_FOUND_NULL;
                            nextBeginOffset = this.nextOffsetCorrection(nextBeginOffset, consumeQueue.rollNextFile(nextBeginOffset));
                            log.warn("consumer request topic:{}, offset:{}, minOffset:{}, maxOffset:{}, but access logic queue failed. correct nextBeginOffset to {}", new Object[]{topic, offset, minOffset, maxOffset, nextBeginOffset});
                            break;
                        }
                        try {
                            CqUnit cqUnit;
                            long nextPhyFileStartOffset = Long.MIN_VALUE;
                            while (bufferConsumeQueue.hasNext() && nextBeginOffset < maxOffset && this.validateCqUnit(cqUnit = (CqUnit)bufferConsumeQueue.next())) {
                                long offsetPy = cqUnit.getPos();
                                int sizePy = cqUnit.getSize();
                                boolean isInDisk = this.checkInDiskByCommitOffset(offsetPy, maxOffsetPy);
                                if (this.isTheBatchFull(sizePy, cqUnit.getBatchNum(), maxMsgNums, maxPullSize, getResult.getBufferTotalSize(), getResult.getMessageCount(), isInDisk) || (long)getResult.getBufferTotalSize() >= maxPullSize) continue block6;
                                maxPhyOffsetPulling = offsetPy;
                                nextBeginOffset = cqUnit.getQueueOffset() + (long)cqUnit.getBatchNum();
                                if (nextPhyFileStartOffset != Long.MIN_VALUE && offsetPy < nextPhyFileStartOffset) continue;
                                SelectMappedBufferResult selectResult = this.getMessage(offsetPy, sizePy);
                                if (null == selectResult) {
                                    if (getResult.getBufferTotalSize() == 0) {
                                        status = GetMessageStatus.MESSAGE_WAS_REMOVING;
                                    }
                                    nextPhyFileStartOffset = this.rollNextFile(offsetPy);
                                    continue;
                                }
                                this.defaultMessageStore.getStoreStatsService().getGetMessageTransferredMsgCount().add(cqUnit.getBatchNum());
                                getResult.addMessage(selectResult, cqUnit.getQueueOffset(), cqUnit.getBatchNum());
                                status = GetMessageStatus.FOUND;
                                nextPhyFileStartOffset = Long.MIN_VALUE;
                            }
                        }
                        finally {
                            bufferConsumeQueue.release();
                        }
                    }
                    getResult.setSuggestPullingFromSlave((diff = maxOffsetPy - maxPhyOffsetPulling) > (memory = (long)((double)StoreUtil.TOTAL_PHYSICAL_MEMORY_SIZE * ((double)this.messageStoreConfig.getAccessMessageInMemoryMaxRatio() / 100.0))));
                }
            } else {
                status = GetMessageStatus.NO_MATCHED_LOGIC_QUEUE;
                nextBeginOffset = this.nextOffsetCorrection(offset, 0L);
            }
            if (GetMessageStatus.FOUND == status) {
                this.defaultMessageStore.getStoreStatsService().getGetMessageTimesTotalFound().add(getResult.getMessageCount());
            } else {
                this.defaultMessageStore.getStoreStatsService().getGetMessageTimesTotalMiss().add(getResult.getMessageCount());
            }
            long elapsedTime = this.defaultMessageStore.getSystemClock().now() - beginTime;
            this.defaultMessageStore.getStoreStatsService().setGetMessageEntireTimeMax(elapsedTime);
            getResult.setStatus(status);
            getResult.setNextBeginOffset(nextBeginOffset);
            getResult.setMaxOffset(maxOffset);
            getResult.setMinOffset(minOffset);
            GetMessageResult getMessageResult = getResult;
            return getMessageResult;
        }
        finally {
            this.readMessageLock.unlock();
        }
    }

    ProcessFileList getCompactionFile() {
        ArrayList mappedFileList = Lists.newArrayList(this.getLog().getMappedFiles());
        if (mappedFileList.size() < 2) {
            return null;
        }
        List<MappedFile> toCompactFiles = mappedFileList.subList(0, mappedFileList.size() - 1);
        ArrayList newFiles = Lists.newArrayList();
        for (int i = 0; i < mappedFileList.size() - 1; ++i) {
            MappedFile mf = (MappedFile)mappedFileList.get(i);
            long maxQueueOffsetInFile = this.getCQ().getMaxMsgOffsetFromFile(mf.getFile().getName());
            if (maxQueueOffsetInFile <= this.positionMgr.getOffset(this.topic, this.queueId)) continue;
            newFiles.add(mf);
        }
        if (newFiles.isEmpty()) {
            return null;
        }
        return new ProcessFileList(toCompactFiles, newFiles);
    }

    void compactAndReplace(ProcessFileList compactFiles) throws Throwable {
        if (compactFiles == null || compactFiles.isEmpty()) {
            return;
        }
        long startTime = System.nanoTime();
        OffsetMap offsetMap = this.getOffsetMap(compactFiles.newFiles);
        this.compaction(compactFiles.toCompactFiles, offsetMap);
        this.replaceFiles(compactFiles.toCompactFiles, this.current, this.compacting);
        this.positionMgr.setOffset(this.topic, this.queueId, offsetMap.lastOffset);
        this.positionMgr.persist();
        this.compacting.clean(false, false);
        log.info("this compaction elapsed {} milliseconds", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
    }

    void doCompaction() {
        if (!this.state.compareAndSet(State.NORMAL, State.COMPACTING)) {
            log.warn("compactionLog state is {}, skip this time", (Object)this.state.get());
            return;
        }
        try {
            this.compactAndReplace(this.getCompactionFile());
        }
        catch (Throwable e) {
            log.error("do compaction exception: ", e);
        }
        this.state.compareAndSet(State.COMPACTING, State.NORMAL);
    }

    protected OffsetMap getOffsetMap(List<MappedFile> mappedFileList) throws NoSuchAlgorithmException, DigestException {
        OffsetMap offsetMap = new OffsetMap(this.offsetMapMemorySize);
        block5: for (MappedFile mappedFile : mappedFileList) {
            Iterator<SelectMappedBufferResult> iterator = mappedFile.iterator(0);
            while (iterator.hasNext()) {
                SelectMappedBufferResult smb = null;
                try {
                    smb = iterator.next();
                    MessageExt msg = MessageDecoder.decode((ByteBuffer)smb.getByteBuffer(), (boolean)true, (boolean)false);
                    if (msg == null) continue block5;
                    if (msg.getQueueOffset() <= this.positionMgr.getOffset(this.topic, this.queueId)) continue;
                    offsetMap.put(msg.getKeys(), msg.getQueueOffset());
                }
                catch (DigestException e) {
                    log.error("offsetMap put exception: ", (Throwable)e);
                    throw e;
                }
                finally {
                    if (smb == null) continue;
                    smb.release();
                }
            }
        }
        return offsetMap;
    }

    protected void putEndMessage(MappedFileQueue mappedFileQueue) {
        MappedFile lastFile = mappedFileQueue.getLastMappedFile();
        if (!lastFile.isFull()) {
            lastFile.appendMessage(ByteBuffer.allocate(0), this.endMsgCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compaction(List<MappedFile> mappedFileList, OffsetMap offsetMap) throws DigestException {
        this.compacting = new TopicPartitionLog(this, COMPACTING_SUB_FOLDER);
        block4: for (MappedFile mappedFile : mappedFileList) {
            Iterator<SelectMappedBufferResult> iterator = mappedFile.iterator(0);
            while (iterator.hasNext()) {
                SelectMappedBufferResult smb = null;
                try {
                    smb = iterator.next();
                    MessageExt msgExt = MessageDecoder.decode((ByteBuffer)smb.getByteBuffer(), (boolean)true, (boolean)true);
                    if (msgExt == null) continue block4;
                    this.checkAndPutMessage(smb, msgExt, offsetMap, this.compacting);
                }
                finally {
                    if (smb == null) continue block4;
                    smb.release();
                    continue block4;
                }
            }
        }
        this.putEndMessage(this.compacting.getLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceFiles(List<MappedFile> mappedFileList, TopicPartitionLog current, TopicPartitionLog newLog) {
        MappedFileQueue dest = current.getLog();
        MappedFileQueue src = newLog.getLog();
        long beginTime = System.nanoTime();
        List<String> fileNameToReplace = dest.getMappedFiles().stream().filter(mappedFileList::contains).map(mf -> mf.getFile().getName()).collect(Collectors.toList());
        mappedFileList.forEach(MappedFile::renameToDelete);
        src.getMappedFiles().forEach(mappedFile -> {
            try {
                mappedFile.flush(0);
                mappedFile.moveToParent();
            }
            catch (IOException e) {
                log.error("move file {} to parent directory exception: ", (Object)mappedFile.getFileName());
            }
        });
        dest.getMappedFiles().stream().filter(m -> !mappedFileList.contains(m)).forEach(m -> src.getMappedFiles().add((MappedFile)m));
        this.readMessageLock.lock();
        try {
            mappedFileList.forEach(mappedFile -> mappedFile.destroy(1000L));
            dest.getMappedFiles().clear();
            dest.getMappedFiles().addAll(src.getMappedFiles());
            src.getMappedFiles().clear();
            this.replaceCqFiles(this.getCQ(), newLog.getCQ(), fileNameToReplace);
            log.info("replace file elapsed {} milliseconds", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginTime));
        }
        finally {
            this.readMessageLock.unlock();
        }
    }

    protected void replaceCqFiles(SparseConsumeQueue currentBcq, SparseConsumeQueue compactionBcq, List<String> fileNameToReplace) {
        long beginTime = System.nanoTime();
        MappedFileQueue currentMq = currentBcq.getMappedFileQueue();
        MappedFileQueue compactMq = compactionBcq.getMappedFileQueue();
        List<MappedFile> fileListToDelete = currentMq.getMappedFiles().stream().filter(m -> fileNameToReplace.contains(m.getFile().getName())).collect(Collectors.toList());
        fileListToDelete.forEach(MappedFile::renameToDelete);
        compactMq.getMappedFiles().forEach(mappedFile -> {
            try {
                mappedFile.flush(0);
                mappedFile.moveToParent();
            }
            catch (IOException e) {
                log.error("move consume queue file {} to parent directory exception: ", (Object)mappedFile.getFileName(), (Object)e);
            }
        });
        currentMq.getMappedFiles().stream().filter(m -> !fileListToDelete.contains(m)).forEach(m -> compactMq.getMappedFiles().add((MappedFile)m));
        fileListToDelete.forEach(mappedFile -> mappedFile.destroy(1000L));
        currentMq.getMappedFiles().clear();
        currentMq.getMappedFiles().addAll(compactMq.getMappedFiles());
        compactMq.getMappedFiles().clear();
        currentBcq.refresh();
        log.info("replace consume queue file elapsed {} millsecs.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginTime));
    }

    public MappedFileQueue getLog() {
        return this.current.mappedFileQueue;
    }

    public SparseConsumeQueue getCQ() {
        return this.current.consumeQueue;
    }

    public void flush(int flushLeastPages) {
        this.flushLog(flushLeastPages);
        this.flushCQ(flushLeastPages);
    }

    public void flushLog(int flushLeastPages) {
        this.getLog().flush(flushLeastPages);
    }

    public void flushCQ(int flushLeastPages) {
        this.getCQ().flush(flushLeastPages);
    }

    static class ProcessFileList {
        List<MappedFile> newFiles;
        List<MappedFile> toCompactFiles;

        public ProcessFileList(List<MappedFile> toCompactFiles, List<MappedFile> newFiles) {
            this.toCompactFiles = toCompactFiles;
            this.newFiles = newFiles;
        }

        boolean isEmpty() {
            return CollectionUtils.isEmpty(this.newFiles) || CollectionUtils.isEmpty(this.toCompactFiles);
        }
    }

    static enum State {
        NORMAL,
        INITIALIZING,
        COMPACTING;

    }

    static class TopicPartitionLog {
        MappedFileQueue mappedFileQueue;
        SparseConsumeQueue consumeQueue;

        public TopicPartitionLog(CompactionLog compactionLog) {
            this(compactionLog, null);
        }

        public TopicPartitionLog(CompactionLog compactionLog, String subFolder) {
            if (StringUtils.isBlank((CharSequence)subFolder)) {
                this.mappedFileQueue = new MappedFileQueue(compactionLog.compactionLogFilePath, compactionLog.compactionLogMappedFileSize, null);
                this.consumeQueue = new SparseConsumeQueue(compactionLog.topic, compactionLog.queueId, compactionLog.compactionCqFilePath, compactionLog.compactionCqMappedFileSize, compactionLog.defaultMessageStore);
            } else {
                this.mappedFileQueue = new MappedFileQueue(compactionLog.compactionLogFilePath + File.separator + subFolder, compactionLog.compactionLogMappedFileSize, null);
                this.consumeQueue = new SparseConsumeQueue(compactionLog.topic, compactionLog.queueId, compactionLog.compactionCqFilePath, compactionLog.compactionCqMappedFileSize, compactionLog.defaultMessageStore, subFolder);
            }
        }

        public void shutdown() {
            this.mappedFileQueue.shutdown(30000L);
            this.consumeQueue.getMappedFileQueue().shutdown(30000L);
        }

        public void init(boolean exitOk) throws IOException, RuntimeException {
            if (!this.mappedFileQueue.load()) {
                this.shutdown();
                throw new IOException("load log exception");
            }
            if (!this.consumeQueue.load()) {
                this.shutdown();
                throw new IOException("load consume queue exception");
            }
            try {
                this.consumeQueue.recover();
                this.recover();
                this.sanityCheck();
            }
            catch (Exception e) {
                this.shutdown();
                throw e;
            }
        }

        private void recover() {
            long maxCqPhysicOffset = this.consumeQueue.getMaxPhyOffsetInLog();
            log.info("{}:{} max physical offset in compaction log is {}", new Object[]{this.consumeQueue.getTopic(), this.consumeQueue.getQueueId(), maxCqPhysicOffset});
            if (maxCqPhysicOffset > 0L) {
                this.mappedFileQueue.setFlushedWhere(maxCqPhysicOffset);
                this.mappedFileQueue.setCommittedWhere(maxCqPhysicOffset);
                this.mappedFileQueue.truncateDirtyFiles(maxCqPhysicOffset);
            }
        }

        void sanityCheck() throws RuntimeException {
            List<MappedFile> mappedFileList = this.mappedFileQueue.getMappedFiles();
            for (MappedFile file : mappedFileList) {
                if (this.consumeQueue.containsOffsetFile(Long.parseLong(file.getFile().getName()))) continue;
                throw new RuntimeException("log file mismatch with consumeQueue file " + file.getFileName());
            }
            List<MappedFile> cqMappedFileList = this.consumeQueue.getMappedFileQueue().getMappedFiles();
            for (MappedFile file : cqMappedFileList) {
                if (!mappedFileList.stream().noneMatch(m -> Objects.equals(m.getFile().getName(), file.getFile().getName()))) continue;
                throw new RuntimeException("consumeQueue file mismatch with log file " + file.getFileName());
            }
        }

        public synchronized void roll() throws IOException {
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
            if (mappedFile == null) {
                throw new IOException("create new file error");
            }
            long baseOffset = mappedFile.getFileFromOffset();
            MappedFile cqFile = this.consumeQueue.createFile(baseOffset);
            if (cqFile == null) {
                mappedFile.destroy(1000L);
                this.mappedFileQueue.getMappedFiles().remove(mappedFile);
                throw new IOException("create new consumeQueue file error");
            }
        }

        public synchronized void roll(int baseOffset) throws IOException {
            MappedFile mappedFile = this.mappedFileQueue.tryCreateMappedFile(baseOffset);
            if (mappedFile == null) {
                throw new IOException("create new file error");
            }
            MappedFile cqFile = this.consumeQueue.createFile(baseOffset);
            if (cqFile == null) {
                mappedFile.destroy(1000L);
                this.mappedFileQueue.getMappedFiles().remove(mappedFile);
                throw new IOException("create new consumeQueue file error");
            }
        }

        public boolean isEmptyOrCurrentFileFull() {
            return this.mappedFileQueue.isEmptyOrCurrentFileFull() || this.consumeQueue.getMappedFileQueue().isEmptyOrCurrentFileFull();
        }

        public void clean(MappedFileQueue mappedFileQueue) throws IOException {
            for (MappedFile mf : mappedFileQueue.getMappedFiles()) {
                if (!mf.getFile().exists()) continue;
                log.error("directory {} with {} not empty.", (Object)mappedFileQueue.getStorePath(), (Object)mf.getFileName());
                throw new IOException("directory " + mappedFileQueue.getStorePath() + " not empty.");
            }
            mappedFileQueue.destroy();
        }

        public void clean(boolean forceCleanLog, boolean forceCleanCq) throws IOException {
            if (forceCleanLog) {
                this.mappedFileQueue.destroy();
            } else {
                this.clean(this.mappedFileQueue);
            }
            if (forceCleanCq) {
                this.consumeQueue.getMappedFileQueue().destroy();
            } else {
                this.clean(this.consumeQueue.getMappedFileQueue());
            }
        }

        public MappedFileQueue getLog() {
            return this.mappedFileQueue;
        }

        public SparseConsumeQueue getCQ() {
            return this.consumeQueue;
        }
    }

    static class OffsetMap {
        private final ByteBuffer dataBytes;
        private final int capacity;
        private final int entrySize;
        private int entryNum;
        private final MessageDigest digest;
        private final int hashSize;
        private long lastOffset;
        private final byte[] hash1;
        private final byte[] hash2;

        public OffsetMap(int memorySize) throws NoSuchAlgorithmException {
            this(memorySize, MessageDigest.getInstance("MD5"));
        }

        public OffsetMap(int memorySize, MessageDigest digest) {
            this.hashSize = digest.getDigestLength();
            this.entrySize = this.hashSize + 8;
            this.capacity = Math.max(memorySize / this.entrySize, 100);
            this.dataBytes = ByteBuffer.allocate(this.capacity * this.entrySize);
            this.hash1 = new byte[this.hashSize];
            this.hash2 = new byte[this.hashSize];
            this.entryNum = 0;
            this.digest = digest;
        }

        public void put(String key, long offset) throws DigestException {
            if (this.entryNum >= this.capacity) {
                throw new IllegalArgumentException("offset map is full");
            }
            this.hashInto(key, this.hash1);
            int tryNum = 0;
            int index = this.indexOf(this.hash1, tryNum);
            while (!this.isEmpty(index)) {
                this.dataBytes.position(index);
                this.dataBytes.get(this.hash2);
                if (Arrays.equals(this.hash1, this.hash2)) {
                    this.dataBytes.putLong(offset);
                    this.lastOffset = offset;
                    return;
                }
                index = this.indexOf(this.hash1, ++tryNum);
            }
            this.dataBytes.position(index);
            this.dataBytes.put(this.hash1);
            this.dataBytes.putLong(offset);
            this.lastOffset = offset;
            ++this.entryNum;
        }

        public long get(String key) throws DigestException {
            this.hashInto(key, this.hash1);
            int tryNum = 0;
            int maxTryNum = this.entryNum + this.hashSize - 4;
            int index = 0;
            do {
                if (tryNum >= maxTryNum) {
                    return -1L;
                }
                index = this.indexOf(this.hash1, tryNum);
                this.dataBytes.position(index);
                if (this.isEmpty(index)) {
                    return -1L;
                }
                this.dataBytes.get(this.hash2);
                ++tryNum;
            } while (!Arrays.equals(this.hash1, this.hash2));
            return this.dataBytes.getLong();
        }

        public long getLastOffset() {
            return this.lastOffset;
        }

        private boolean isEmpty(int pos) {
            return this.dataBytes.getLong(pos) == 0L && this.dataBytes.getLong(pos + 8) == 0L && this.dataBytes.getLong(pos + 16) == 0L;
        }

        private int indexOf(byte[] hash, int tryNum) {
            int index = this.readInt(hash, Math.min(tryNum, this.hashSize - 4)) + Math.max(0, tryNum - this.hashSize + 4);
            int entry = Math.abs(index) % this.capacity;
            return entry * this.entrySize;
        }

        private void hashInto(String key, byte[] buf) throws DigestException {
            this.digest.update(key.getBytes(StandardCharsets.UTF_8));
            this.digest.digest(buf, 0, this.hashSize);
        }

        private int readInt(byte[] buf, int offset) {
            return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        }
    }

    static class CompactionAppendMessageCallback
    implements CompactionAppendMsgCallback {
        private final String topic;
        private final int queueId;
        private final long tagsCode;
        private final long storeTimestamp;
        private final SparseConsumeQueue bcq;

        public CompactionAppendMessageCallback(MessageExt msgExt, SparseConsumeQueue bcq) {
            this.topic = msgExt.getTopic();
            this.queueId = msgExt.getQueueId();
            this.tagsCode = MessageExtBrokerInner.tagsString2tagsCode((String)msgExt.getTags());
            this.storeTimestamp = msgExt.getStoreTimestamp();
            this.bcq = bcq;
        }

        public CompactionAppendMessageCallback(String topic, int queueId, long tagsCode, long storeTimestamp, SparseConsumeQueue bcq) {
            this.topic = topic;
            this.queueId = queueId;
            this.tagsCode = tagsCode;
            this.storeTimestamp = storeTimestamp;
            this.bcq = bcq;
        }

        @Override
        public AppendMessageResult doAppend(ByteBuffer bbDest, long fileFromOffset, int maxBlank, ByteBuffer bbSrc) {
            int msgLen = bbSrc.getInt(0);
            MappedFile bcqMappedFile = this.bcq.getMappedFileQueue().getLastMappedFile();
            if (bcqMappedFile.getWrotePosition() + 46 >= bcqMappedFile.getFileSize() || msgLen + 8 > maxBlank) {
                this.bcq.putEndPositionInfo(bcqMappedFile);
                bbDest.putInt(maxBlank);
                bbDest.putInt(-875286124);
                return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, fileFromOffset + (long)bbDest.position(), maxBlank, this.storeTimestamp);
            }
            int logicOffsetPos = 20;
            long logicOffset = bbSrc.getLong(logicOffsetPos);
            int destPos = bbDest.position();
            long physicalOffset = fileFromOffset + (long)bbDest.position();
            bbSrc.rewind();
            bbSrc.limit(msgLen);
            bbDest.put(bbSrc);
            bbDest.putLong(destPos + logicOffsetPos + 8, physicalOffset);
            boolean result = this.bcq.putBatchMessagePositionInfo(physicalOffset, msgLen, this.tagsCode, this.storeTimestamp, logicOffset, (short)1);
            if (!result) {
                log.error("put message {}-{} position info failed", (Object)this.topic, (Object)this.queueId);
            }
            return new AppendMessageResult(AppendMessageStatus.PUT_OK, physicalOffset, msgLen, this.storeTimestamp);
        }
    }

    static class CompactionAppendEndMsgCallback
    implements CompactionAppendMsgCallback {
        CompactionAppendEndMsgCallback() {
        }

        @Override
        public AppendMessageResult doAppend(ByteBuffer bbDest, long fileFromOffset, int maxBlank, ByteBuffer bbSrc) {
            ByteBuffer endInfo = ByteBuffer.allocate(8);
            endInfo.putInt(maxBlank);
            endInfo.putInt(-875286124);
            return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, fileFromOffset + (long)bbDest.position(), maxBlank, System.currentTimeMillis());
        }
    }
}

