/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionPool;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.FutureTaskUtil;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.remoting.util.RunStateRecordedFutureTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ScheduledDisconnectStrategy
implements ConnectionMonitorStrategy {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private final int connectionThreshold = ConfigManager.conn_threshold();
    private final Random random = new Random();

    @Override
    @Deprecated
    public Map<String, List<Connection>> filter(List<Connection> connections) {
        ArrayList<Connection> serviceOnConnections = new ArrayList<Connection>();
        ArrayList<Connection> serviceOffConnections = new ArrayList<Connection>();
        ConcurrentHashMap<String, List<Connection>> filteredConnections = new ConcurrentHashMap<String, List<Connection>>();
        for (Connection connection : connections) {
            if (this.isConnectionOn(connection)) {
                serviceOnConnections.add(connection);
                continue;
            }
            serviceOffConnections.add(connection);
        }
        filteredConnections.put("on", serviceOnConnections);
        filteredConnections.put("off", serviceOffConnections);
        return filteredConnections;
    }

    @Override
    public void monitor(Map<String, RunStateRecordedFutureTask<ConnectionPool>> connPools) {
        try {
            if (connPools == null || connPools.size() == 0) {
                return;
            }
            for (Map.Entry<String, RunStateRecordedFutureTask<ConnectionPool>> entry : connPools.entrySet()) {
                String poolKey = entry.getKey();
                ConnectionPool pool = FutureTaskUtil.getFutureTaskResult(entry.getValue(), logger);
                ArrayList<Connection> serviceOnConnections = new ArrayList<Connection>();
                ArrayList<Connection> serviceOffConnections = new ArrayList<Connection>();
                for (Connection connection : pool.getAll()) {
                    if (this.isConnectionOn(connection)) {
                        serviceOnConnections.add(connection);
                        continue;
                    }
                    serviceOffConnections.add(connection);
                }
                if (serviceOnConnections.size() > this.connectionThreshold) {
                    Connection freshSelectConnect = (Connection)serviceOnConnections.get(this.random.nextInt(serviceOnConnections.size()));
                    freshSelectConnect.setAttribute("bolt.conn.service.status", "off");
                    serviceOffConnections.add(freshSelectConnect);
                } else if (logger.isInfoEnabled()) {
                    logger.info("serviceOnConnections({}) size[{}], CONNECTION_THRESHOLD[{}].", new Object[]{poolKey, serviceOnConnections.size(), this.connectionThreshold});
                }
                for (Connection offConn : serviceOffConnections) {
                    if (offConn.isInvokeFutureMapFinish()) {
                        if (!offConn.isFine()) continue;
                        offConn.close();
                        continue;
                    }
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Address={} won't close at this schedule turn", (Object)RemotingUtil.parseRemoteAddress(offConn.getChannel()));
                }
            }
        }
        catch (Exception e) {
            logger.error("ScheduledDisconnectStrategy monitor error", (Throwable)e);
        }
    }

    private boolean isConnectionOn(Connection connection) {
        String serviceStatus = (String)connection.getAttribute("bolt.conn.service.status");
        return serviceStatus == null || Boolean.parseBoolean(serviceStatus);
    }
}

