/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;

public final class PrometheusHttpServerBuilder {
    static final int DEFAULT_PORT = 9464;
    private static final String DEFAULT_HOST = "0.0.0.0";
    private String host = "0.0.0.0";
    private int port = 9464;
    @Nullable
    private ExecutorService executor;

    public PrometheusHttpServerBuilder setHost(String host) {
        Objects.requireNonNull(host, "host");
        Utils.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (String)"host must not be empty");
        this.host = host;
        return this;
    }

    public PrometheusHttpServerBuilder setPort(int port) {
        Utils.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"port must be positive");
        this.port = port;
        return this;
    }

    public PrometheusHttpServerBuilder setExecutor(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
        return this;
    }

    public PrometheusHttpServer build() {
        ExecutorService executorService = this.executor;
        if (executorService == null) {
            executorService = PrometheusHttpServerBuilder.getDefaultExecutor();
        }
        return new PrometheusHttpServer(this.host, this.port, executorService);
    }

    PrometheusHttpServerBuilder() {
    }

    private static ExecutorService getDefaultExecutor() {
        return Executors.newFixedThreadPool(5, (ThreadFactory)new DaemonThreadFactory("prometheus-http"));
    }
}

