/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.index;

import java.nio.ByteBuffer;

public class IndexItem {
    public static final int INDEX_ITEM_SIZE = 32;
    public static final int COMPACT_INDEX_ITEM_SIZE = 28;
    private final int hashCode;
    private final int topicId;
    private final int queueId;
    private final long offset;
    private final int size;
    private final int timeDiff;
    private final int itemIndex;

    public IndexItem(int topicId, int queueId, long offset, int size, int hashCode, int timeDiff, int itemIndex) {
        this.hashCode = hashCode;
        this.topicId = topicId;
        this.queueId = queueId;
        this.offset = offset;
        this.size = size;
        this.timeDiff = timeDiff;
        this.itemIndex = itemIndex;
    }

    public IndexItem(byte[] bytes) {
        if (bytes == null || bytes.length != 32 && bytes.length != 28) {
            throw new IllegalArgumentException("Byte array length not correct");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        this.hashCode = byteBuffer.getInt(0);
        this.topicId = byteBuffer.getInt(4);
        this.queueId = byteBuffer.getInt(8);
        this.offset = byteBuffer.getLong(12);
        this.size = byteBuffer.getInt(20);
        this.timeDiff = byteBuffer.getInt(24);
        this.itemIndex = bytes.length == 32 ? byteBuffer.getInt(28) : 0;
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        byteBuffer.putInt(0, this.hashCode);
        byteBuffer.putInt(4, this.topicId);
        byteBuffer.putInt(8, this.queueId);
        byteBuffer.putLong(12, this.offset);
        byteBuffer.putInt(20, this.size);
        byteBuffer.putInt(24, this.timeDiff);
        byteBuffer.putInt(28, this.itemIndex);
        return byteBuffer;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public int getTopicId() {
        return this.topicId;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getTimeDiff() {
        return this.timeDiff;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public String toString() {
        return "IndexItem{hashCode=" + this.hashCode + ", topicId=" + this.topicId + ", queueId=" + this.queueId + ", offset=" + this.offset + ", size=" + this.size + ", timeDiff=" + this.timeDiff + ", position=" + this.itemIndex + '}';
    }
}

