/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.auth.pipeline;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.auth.authorization.AuthorizationEvaluator;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.exception.AuthorizationException;
import org.apache.rocketmq.auth.authorization.factory.AuthorizationFactory;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.AbortProcessException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AuthorizationPipeline
implements RequestPipeline {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final AuthConfig authConfig;
    private final AuthorizationEvaluator evaluator;

    public AuthorizationPipeline(AuthConfig authConfig) {
        this.authConfig = authConfig;
        this.evaluator = AuthorizationFactory.getEvaluator((AuthConfig)authConfig);
    }

    public void execute(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        if (!this.authConfig.isAuthorizationEnabled()) {
            return;
        }
        try {
            List<AuthorizationContext> contexts = this.newContexts(ctx, request);
            this.evaluator.evaluate(contexts);
        }
        catch (AuthenticationException | AuthorizationException ex) {
            throw new AbortProcessException(16, ex.getMessage());
        }
        catch (Throwable ex) {
            LOGGER.error("authorization failed, request:{}", (Object)request, (Object)ex);
            throw ex;
        }
    }

    protected List<AuthorizationContext> newContexts(ChannelHandlerContext ctx, RemotingCommand request) {
        return AuthorizationFactory.newContexts((AuthConfig)this.authConfig, (ChannelHandlerContext)ctx, (RemotingCommand)request);
    }
}

