/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.internal;

import com.alipay.sofa.jraft.util.internal.LongFieldUpdater;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class UnsafeLongFieldUpdater<U>
implements LongFieldUpdater<U> {
    private final long offset;
    private final Unsafe unsafe;

    UnsafeLongFieldUpdater(Unsafe unsafe, Class<? super U> tClass, String fieldName) throws NoSuchFieldException {
        Field field = tClass.getDeclaredField(fieldName);
        if (unsafe == null) {
            throw new NullPointerException("unsafe");
        }
        this.unsafe = unsafe;
        this.offset = unsafe.objectFieldOffset(field);
    }

    @Override
    public void set(U obj, long newValue) {
        this.unsafe.putLong(obj, this.offset, newValue);
    }

    @Override
    public long get(U obj) {
        return this.unsafe.getLong(obj, this.offset);
    }
}

