/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import flash.util.ExceptionUtil;
import java.util.Date;

public class Trace {
    public static final boolean all = System.getProperty("trace.flex") != null;
    public static final boolean phase = all || System.getProperty("trace.phase") != null;
    public static final boolean phaseabc = all || System.getProperty("trace.phaseabc") != null;
    public static final boolean accessible = all || System.getProperty("trace.accessible") != null;
    public static final boolean asdoc = all || System.getProperty("trace.asdoc") != null;
    public static final boolean cache = all || System.getProperty("trace.cache") != null;
    public static final boolean css = all || System.getProperty("trace.css") != null;
    public static final boolean dependency = all || System.getProperty("trace.dependency") != null;
    public static final boolean config = all || System.getProperty("trace.config") != null;
    public static final boolean embed = all || System.getProperty("trace.embed") != null;
    public static final boolean error = all || System.getProperty("trace.error") != null;
    public static final boolean font = all || System.getProperty("trace.font") != null;
    public static final boolean font_cubic = all || System.getProperty("trace.font.cubic") != null;
    public static final boolean license = all || System.getProperty("trace.license") != null;
    public static final boolean mxml = all || System.getProperty("trace.mxml") != null;
    public static final boolean profiler = all || System.getProperty("trace.profiler") != null;
    public static final boolean swc = all || System.getProperty("trace.swc") != null;
    public static final boolean pathResolver = all || System.getProperty("trace.pathResolver") != null;
    public static final boolean binding = all || System.getProperty("trace.binding") != null;
    public static final boolean caller = System.getProperty("trace.caller") != null;
    public static final String stackPrefix = System.getProperty("trace.stackPrefix");
    public static int stackLines = 0;
    public static final boolean timeStamp;
    public static final boolean timeStampMs;
    public static final boolean timeStampMsRel;
    public static final boolean swcChecksum;
    private static long t0;

    public static void trace(String str) {
        if (timeStamp) {
            System.err.print(new Date());
        }
        if (timeStampMs || timeStampMsRel) {
            if (timeStampMsRel && t0 == 0L) {
                t0 = System.currentTimeMillis();
            }
            System.err.print(System.currentTimeMillis() - t0 + " ");
        }
        if (caller) {
            System.err.print(ExceptionUtil.getCallAt(new Throwable(), 1) + " ");
        }
        System.err.println(str);
        if (stackLines > 0) {
            System.err.println(ExceptionUtil.getStackTraceLines(new Throwable(), stackLines));
        } else if (stackPrefix != null) {
            System.err.println(ExceptionUtil.getStackTraceUpTo(new Throwable(), stackPrefix));
        }
    }

    public static void resetRel() {
        Trace.trace("Relative clock will reset to zero");
        t0 = 0L;
        Trace.trace("Relative clock new reset");
    }

    static {
        try {
            stackLines = Integer.parseInt(System.getProperty("trace.stackLines"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        timeStamp = System.getProperty("trace.timeStamp") != null;
        timeStampMs = System.getProperty("trace.timeStampMs") != null;
        timeStampMsRel = System.getProperty("trace.timeStampMsRel") != null;
        swcChecksum = all || System.getProperty("trace.swcChecksum") != null;
        t0 = 0L;
    }
}

