/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger;

import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.ILauncher;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDebuggerCallbacks
implements IDebuggerCallbacks {
    private boolean m_computedExeLocations;
    private File m_httpExe;
    private File m_playerExe;
    private static final String UNIX_DEFAULT_BROWSER = "firefox";
    private static final String UNIX_FLASH_PLAYER = "flashplayer";
    private static final int WINDOWS = 0;
    private static final int MAC = 1;
    private static final int UNIX = 2;
    private static final Pattern registryValuePattern = Pattern.compile("\\sREG_[^ \t]+\\s+(.*)$");

    private static int getOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            return 0;
        }
        if (string.startsWith("mac os x")) {
            return 1;
        }
        return 2;
    }

    @Override
    public synchronized File getHttpExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_httpExe;
    }

    @Override
    public synchronized File getPlayerExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_playerExe;
    }

    @Override
    public synchronized void recomputeExeLocations() {
        int n = DefaultDebuggerCallbacks.getOS();
        if (n == 0) {
            this.m_httpExe = this.getDefaultWindowsBrowser();
            this.m_playerExe = this.determineExeForType("ShockwaveFlash.ShockwaveFlash");
        } else if (n == 1) {
            this.m_httpExe = null;
            this.m_playerExe = null;
        } else {
            this.m_httpExe = this.findUnixProgram(UNIX_DEFAULT_BROWSER);
            this.m_playerExe = this.findUnixProgram(UNIX_FLASH_PLAYER);
        }
        this.m_computedExeLocations = true;
    }

    @Override
    public String getHttpExeName() {
        if (DefaultDebuggerCallbacks.getOS() == 2) {
            return UNIX_DEFAULT_BROWSER;
        }
        return Bootstrap.getLocalizationManager().getLocalizedTextString("webBrowserGenericName");
    }

    @Override
    public String getPlayerExeName() {
        if (DefaultDebuggerCallbacks.getOS() == 2) {
            return UNIX_FLASH_PLAYER;
        }
        return Bootstrap.getLocalizationManager().getLocalizedTextString("flashPlayerGenericName");
    }

    private File findUnixProgram(String string) {
        String[] stringArray = new String[]{"/bin/sh", "-c", "which " + string};
        try {
            File file;
            Object object;
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            if (string2 != null && ((File)(object = new File(string2))).exists()) {
                return object;
            }
            object = System.getProperty("application.home");
            if (object != null && (file = new File((String)object, "bin/" + string)).exists()) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File getDefaultWindowsBrowser() {
        try {
            String string;
            double d;
            String string2 = null;
            try {
                d = Double.parseDouble(System.getProperty("os.version"));
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            if (d >= 6.0 && (string = this.queryWindowsRegistry("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice", "Progid")) != null) {
                string2 = this.getClassShellOpenCommand(string);
            }
            if (string2 == null) {
                string2 = this.getClassShellOpenCommand("http");
            }
            if (string2 != null) {
                string2 = this.extractExenameFromCommandString(string2);
                return new File(string2);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getClassShellOpenCommand(String string) throws IOException {
        return this.queryWindowsRegistry("HKEY_CLASSES_ROOT\\" + string + "\\shell\\open\\command", null);
    }

    private File determineExeForType(String object) {
        String string = null;
        try {
            String string2;
            String[] stringArray = new String[]{"cmd", "/d", "/c", "ftype", object};
            Process process = Runtime.getRuntime().exec(stringArray);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
            object = (String)object + "=";
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (string2.length() >= ((String)object).length() && string2.substring(0, ((String)object).length()).compareToIgnoreCase((String)object) != 0) continue;
                string = string2;
                break;
            }
            process.destroy();
            if (string != null) {
                int n = string.indexOf(61);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                string = this.extractExenameFromCommandString(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string != null) {
            return new File(string);
        }
        return null;
    }

    protected String extractExenameFromCommandString(String string) {
        if (string.startsWith("\"")) {
            int n = string.indexOf(34, 1);
            if (n == -1) {
                n = string.length();
            }
            string = string.substring(1, n);
        } else {
            int n = -1;
            while (true) {
                int n2;
                if ((n2 = string.indexOf(32, n + 1)) == -1) {
                    n = -1;
                    break;
                }
                Object object = string.substring(0, n2);
                if (!((String)object).toLowerCase().endsWith(".exe")) {
                    object = (String)object + ".exe";
                }
                if (new File((String)object).exists()) {
                    n = n2;
                    break;
                }
                n = n2;
            }
            if (n != -1 && n < string.length()) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public Process launchDebugTarget(String[] stringArray) throws IOException {
        return Runtime.getRuntime().exec(stringArray);
    }

    @Override
    public Process launchDebugTarget(String[] stringArray, ILauncher iLauncher) throws IOException {
        return iLauncher.launch(stringArray);
    }

    @Override
    public void terminateDebugTarget(Process process) throws IOException {
        this.terminateDebugTarget(process, null);
    }

    @Override
    public void terminateDebugTarget(Process process, ILauncher iLauncher) throws IOException {
        if (null == iLauncher) {
            process.destroy();
        } else {
            iLauncher.terminate(process);
        }
    }

    @Override
    public String queryWindowsRegistry(String string, String string2) throws IOException {
        return this.queryWindowsRegistry(string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryWindowsRegistry(String string, String string2, int n) throws IOException {
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("reg.exe");
        arrayList.add("query");
        arrayList.add(string);
        if (string2 == null || string2.length() == 0) {
            arrayList.add("/ve");
        } else {
            arrayList.add("/v");
            arrayList.add(string2);
        }
        Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                Matcher matcher;
                if (!string4.equalsIgnoreCase(string)) continue;
                string4 = bufferedReader.readLine();
                if (string4 != null && (matcher = registryValuePattern.matcher(string4)).find()) {
                    string3 = matcher.group(1);
                }
                break;
            }
        }
        catch (IOException iOException) {
            if (Trace.error) {
                iOException.printStackTrace();
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return string3;
    }

    @Override
    public int[] getAppVersion(File file) throws IOException {
        return null;
    }

    @Override
    public String[] getBrowserParameters(String string) {
        return null;
    }
}

