/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Frame;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.PlayerSession;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DStackContext
implements Frame {
    private DModule m_source;
    private String m_functionSignature;
    private int m_depth;
    private int m_module;
    private int m_line;
    private DVariable m_this;
    private Map<String, DVariable> m_args;
    private Map<String, DVariable> m_locals;
    private List<DVariable> m_scopeChain;
    private DLocation m_location;
    private int m_swfIndex;
    private int m_offset;
    private boolean m_populated;
    private DVariable m_activationObject;
    private int m_isolateId;

    public DStackContext(int n, int n2, DModule dModule, long l, String string, int n3, int n4) {
        this.m_source = dModule;
        this.m_module = n;
        this.m_line = n2;
        this.m_this = null;
        this.m_functionSignature = string;
        this.m_depth = n3;
        this.m_args = new LinkedHashMap<String, DVariable>();
        this.m_locals = new LinkedHashMap<String, DVariable>();
        this.m_scopeChain = new ArrayList<DVariable>();
        this.m_populated = false;
        this.m_isolateId = n4;
        this.m_location = new DLocation(this.m_source, n2, n4);
    }

    @Override
    public Location getLocation() {
        return this.m_location;
    }

    @Override
    public Variable[] getArguments(Session session) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(session);
        return this.m_args.values().toArray(new Variable[this.m_args.size()]);
    }

    @Override
    public Variable[] getLocals(Session session) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(session);
        return this.m_locals.values().toArray(new Variable[this.m_locals.size()]);
    }

    @Override
    public Variable getThis(Session session) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(session);
        return this.getThis();
    }

    @Override
    public Variable[] getScopeChain(Session session) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(session);
        return this.m_scopeChain.toArray(new Variable[this.m_scopeChain.size()]);
    }

    @Override
    public String getCallSignature() {
        return this.m_functionSignature;
    }

    public int getModule() {
        return this.m_module;
    }

    public int getLine() {
        return this.m_line;
    }

    public DVariable getThis() {
        return this.m_this;
    }

    void addArgument(DVariable dVariable) {
        this.m_args.put(dVariable.getName(), dVariable);
    }

    void addLocal(DVariable dVariable) {
        this.m_locals.put(dVariable.getName(), dVariable);
    }

    void addScopeChainEntry(DVariable dVariable) {
        this.m_scopeChain.add(dVariable);
    }

    void removeAllArguments() {
        this.m_args.clear();
    }

    void removeAllLocals() {
        this.m_locals.clear();
        this.m_activationObject = null;
    }

    void removeAllScopeChainEntries() {
        this.m_scopeChain.clear();
    }

    void removeAllVariables() {
        this.removeAllLocals();
        this.removeAllArguments();
        this.removeAllScopeChainEntries();
    }

    void setDepth(int n) {
        this.m_depth = n;
    }

    void setThis(DVariable dVariable) {
        this.m_this = dVariable;
    }

    void setSwfIndex(int n) {
        this.m_swfIndex = n;
    }

    void setOffset(int n) {
        this.m_offset = n;
    }

    void setIsolateId(int n) {
        this.m_isolateId = n;
    }

    void markStale() {
        this.m_populated = false;
    }

    void convertLocalToActivationObject(DVariable dVariable) {
        this.m_activationObject = dVariable;
        this.m_locals.remove(dVariable.getName());
    }

    DVariable getActivationObject() {
        return this.m_activationObject;
    }

    void populate(Session session) throws NoResponseException, NotSuspendedException, NotConnectedException {
        if (!this.m_populated) {
            PlayerSession playerSession = (PlayerSession)session;
            playerSession.requestFrame(this.m_depth, this.m_isolateId);
            this.m_populated = true;
        }
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }
}

