/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.caches;

import java.io.IOException;
import java.util.Collection;
import org.apache.royale.compiler.caches.IFileScopeCache;
import org.apache.royale.compiler.internal.abc.ABCScopeBuilder;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.royale.compiler.internal.caches.SWFCache;
import org.apache.royale.compiler.internal.scopes.SWCFileScopeProvider;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCScript;
import org.apache.royale.swc.SWCManager;
import org.apache.royale.swf.ITagContainer;
import org.apache.royale.swf.tags.DoABCTag;

public class FileScopeCache
extends ConcurrentCacheStoreBase<Collection<IASScope>>
implements IFileScopeCache {
    private final SWCManager swcManager;

    public static FileScopeCacheKey createKey(ISWC swc, String librarySWFPath, ISWCScript script) {
        FileScopeCacheKey key = new FileScopeCacheKey();
        key.swc = swc;
        key.swfPath = librarySWFPath;
        key.scriptName = script.getName();
        return key;
    }

    public FileScopeCache(SWCManager swcManager) {
        this.swcManager = swcManager;
    }

    @Override
    protected Collection<IASScope> createEntryValue(CacheStoreKeyBase key) {
        if (!(key instanceof FileScopeCacheKey)) {
            throw new IllegalArgumentException("expect FileScopeCacheKey but got " + key.getClass().getSimpleName());
        }
        FileScopeCacheKey fileScopeCacheKey = (FileScopeCacheKey)key;
        SWFCache.SWFInSWCCacheKey swfCacheKey = SWFCache.createKey(fileScopeCacheKey.swc, fileScopeCacheKey.swfPath);
        ITagContainer tags = (ITagContainer)((SWFCache)this.swcManager.getSWFCache()).get(swfCacheKey);
        DoABCTag abcTag = SWFCache.findDoABCTagByName(tags, fileScopeCacheKey.scriptName);
        if (abcTag != null) {
            try {
                ABCScopeBuilder abcScopeBuilder = new ABCScopeBuilder(this.swcManager.getWorkspace(), abcTag.getABCData(), fileScopeCacheKey.swc.getSWCFile().getCanonicalPath(), SWCFileScopeProvider.getInstance());
                return abcScopeBuilder.build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("can't create entry in FileScopeCache for key: " + key.toString());
    }

    protected static class FileScopeCacheKey
    extends SWFCache.SWFInSWCCacheKey {
        protected String scriptName;

        protected FileScopeCacheKey() {
        }

        @Override
        public String generateKey() {
            return String.format("%s:%s:%s", this.swc.getSWCFile().getAbsolutePath(), this.swfPath, this.scriptName).intern();
        }
    }
}

