/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import java.util.StringTokenizer;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;

public class CSSRgbColorPropertyValue
extends CSSPropertyValue {
    private final Token token;
    private final int colorInt;
    private final String rawRgb;

    protected CSSRgbColorPropertyValue(String rawRgb, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        this.token = tree.token;
        this.rawRgb = rawRgb;
        this.colorInt = CSSRgbColorPropertyValue.getIntValue(this.rawRgb);
    }

    protected static int getIntValue(String rgb) {
        rgb = rgb.substring(4, rgb.length() - 1);
        StringTokenizer st = new StringTokenizer(rgb, ",");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreElements()) {
            int digit;
            String t = (String)st.nextElement();
            if ((t = t.trim()).contains("%")) {
                t = t.replaceAll("%", "");
                digit = Float.valueOf(t).intValue() * 255 / 100;
                sb.append(Character.forDigit(digit >> 4 & 0xF, 16));
                sb.append(Character.forDigit(digit & 0xF, 16));
                continue;
            }
            digit = Float.valueOf(t).intValue();
            sb.append(Character.forDigit(digit >> 4 & 0xF, 16));
            sb.append(Character.forDigit(digit & 0xF, 16));
        }
        return Integer.parseInt(sb.toString(), 16);
    }

    public int getColorAsInt() {
        return this.colorInt;
    }

    public String getRawRgb() {
        return this.rawRgb;
    }

    @Override
    public String toString() {
        return this.token.getText();
    }
}

