package org.apache.rya.accumulo.experimental;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


import java.io.IOException;
import java.util.Collection;

import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaIRI;

import org.apache.accumulo.core.client.MultiTableBatchWriter;

public abstract class AbstractAccumuloIndexer implements AccumuloIndexer {

    @Override
    public void setMultiTableBatchWriter(MultiTableBatchWriter writer) throws IOException {
    }

    @Override
    public void storeStatements(Collection<RyaStatement> statements) throws IOException {
        for (RyaStatement s : statements) {
            storeStatement(s);
        }
    }

    @Override
    public void deleteStatement(RyaStatement stmt) throws IOException {
    }

    @Override
    public void dropGraph(RyaIRI... graphs) {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}
