/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore;

import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.semaphore.AcquireInvocationKey;
import com.hazelcast.cp.internal.datastructures.semaphore.AcquireResult;
import com.hazelcast.cp.internal.datastructures.semaphore.ReleaseResult;
import com.hazelcast.cp.internal.datastructures.semaphore.Semaphore;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreEndpoint;
import com.hazelcast.cp.internal.datastructures.spi.blocking.ResourceRegistry;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public class SemaphoreRegistry
extends ResourceRegistry<AcquireInvocationKey, Semaphore>
implements IdentifiedDataSerializable {
    private CPSubsystemConfig cpSubsystemConfig;

    SemaphoreRegistry() {
    }

    SemaphoreRegistry(CPGroupId groupId, CPSubsystemConfig cpSubsystemConfig) {
        super(groupId);
        this.cpSubsystemConfig = cpSubsystemConfig;
    }

    public void setCpSubsystemConfig(CPSubsystemConfig cpSubsystemConfig) {
        this.cpSubsystemConfig = cpSubsystemConfig;
    }

    @Override
    protected Semaphore createNewResource(CPGroupId groupId, String name) {
        SemaphoreConfig semaphoreConfig = this.cpSubsystemConfig.findSemaphoreConfig(name);
        int initialPermits = semaphoreConfig != null ? semaphoreConfig.getInitialPermits() : 0;
        return new Semaphore(groupId, name, initialPermits);
    }

    protected SemaphoreRegistry cloneForSnapshot() {
        SemaphoreRegistry clone2 = new SemaphoreRegistry();
        clone2.groupId = this.groupId;
        for (Map.Entry e : this.resources.entrySet()) {
            clone2.resources.put(e.getKey(), ((Semaphore)e.getValue()).cloneForSnapshot());
        }
        clone2.destroyedNames.addAll(this.destroyedNames);
        clone2.waitTimeouts.putAll(this.waitTimeouts);
        return clone2;
    }

    Collection<AcquireInvocationKey> init(String name, int permits) {
        Collection<AcquireInvocationKey> acquired = ((Semaphore)this.getOrInitResource(name)).init(permits);
        for (AcquireInvocationKey key : acquired) {
            this.removeWaitKey(name, key);
        }
        return acquired;
    }

    int availablePermits(String name) {
        return ((Semaphore)this.getOrInitResource(name)).getAvailable();
    }

    AcquireResult acquire(String name, AcquireInvocationKey key, long timeoutMs) {
        AcquireResult result2 = ((Semaphore)this.getOrInitResource(name)).acquire(key, timeoutMs != 0L);
        for (AcquireInvocationKey waitKey : result2.cancelledWaitKeys()) {
            this.removeWaitKey(name, waitKey);
        }
        if (result2.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
            this.addWaitKey(name, key, timeoutMs);
        }
        return result2;
    }

    ReleaseResult release(String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        ReleaseResult result2 = ((Semaphore)this.getOrInitResource(name)).release(endpoint, invocationUid, permits);
        for (AcquireInvocationKey key : result2.acquiredWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        for (AcquireInvocationKey key : result2.cancelledWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        return result2;
    }

    AcquireResult drainPermits(String name, SemaphoreEndpoint endpoint, UUID invocationUid) {
        AcquireResult result2 = ((Semaphore)this.getOrInitResource(name)).drain(endpoint, invocationUid);
        for (AcquireInvocationKey key : result2.cancelledWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        return result2;
    }

    ReleaseResult changePermits(String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        ReleaseResult result2 = ((Semaphore)this.getOrInitResource(name)).change(endpoint, invocationUid, permits);
        for (AcquireInvocationKey key : result2.acquiredWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        for (AcquireInvocationKey key : result2.cancelledWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        return result2;
    }

    Collection<Semaphore> getAllSemaphores() {
        return this.resources.values();
    }

    @Override
    public int getFactoryId() {
        return SemaphoreDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

