/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PickAnyAccumulator<T> {
    private T value;
    private long count;

    public PickAnyAccumulator() {
    }

    public PickAnyAccumulator(T value, long count2) {
        this.value = value;
        this.count = count2;
    }

    public void accumulate(@Nullable T t) {
        if (t == null) {
            return;
        }
        if (this.value == null) {
            this.value = t;
        }
        ++this.count;
    }

    public void combine(@Nonnull PickAnyAccumulator<T> other) {
        this.count += other.count;
        if (this.value == null) {
            this.value = other.value;
        }
    }

    public void deduct(@Nonnull PickAnyAccumulator<T> other) {
        this.count -= other.count;
        assert (this.count >= 0L) : "Negative count after deduct";
        if (this.count == 0L) {
            this.value = null;
        }
    }

    public T get() {
        return this.value;
    }

    public long count() {
        return this.count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null) return false;
        if (this.getClass() != o.getClass()) return false;
        PickAnyAccumulator that = (PickAnyAccumulator)o;
        if (this.count != that.count) return false;
        if (!Objects.equals(this.value, that.value)) return false;
        return true;
    }

    public int hashCode() {
        long hc = 17L;
        hc = 73L * hc + this.count;
        hc = 73L * hc + (long)(this.value != null ? this.value.hashCode() : 0);
        return Long.hashCode(hc);
    }

    public String toString() {
        return "MutableReference(" + this.value + ')';
    }
}

