/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.cache;

import com.hazelcast.sql.impl.optimizer.PlanCheckContext;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class PlanCache
implements CachedPlanInvalidationCallback {
    private final int maxSize;
    private final ConcurrentHashMap<PlanKey, SqlPlan> plans = new ConcurrentHashMap();

    public PlanCache(int maxSize) {
        assert (maxSize > 0);
        this.maxSize = maxSize;
    }

    public SqlPlan get(PlanKey key) {
        SqlPlan plan = this.plans.get(key);
        if (plan != null) {
            plan.onPlanUsed();
            return plan;
        }
        return null;
    }

    public void put(PlanKey key, SqlPlan plan) {
        plan.onPlanUsed();
        this.plans.put(key, plan);
        this.shrinkIfNeeded();
    }

    @Override
    public void invalidate(SqlPlan plan) {
        this.remove(plan);
    }

    public void clear() {
        this.plans.clear();
    }

    public int size() {
        return this.plans.size();
    }

    public void check(PlanCheckContext context) {
        this.plans.values().removeIf(plan -> !plan.isPlanValid(context));
    }

    private void shrinkIfNeeded() {
        boolean removed;
        SqlPlan plan2;
        int oversize = this.plans.size() - this.maxSize;
        if (oversize <= 0) {
            return;
        }
        TreeMap<Long, SqlPlan> sorted2 = new TreeMap<Long, SqlPlan>();
        for (SqlPlan plan2 : this.plans.values()) {
            sorted2.put(plan2.getPlanLastUsed(), plan2);
        }
        Iterator<SqlPlan> iterator2 = sorted2.values().iterator();
        while (iterator2.hasNext() && (!(removed = this.remove(plan2 = iterator2.next())) || --oversize != 0)) {
        }
    }

    private boolean remove(SqlPlan plan) {
        return this.plans.remove(plan.getPlanKey(), plan);
    }

    public ConcurrentHashMap<PlanKey, SqlPlan> getPlans() {
        return this.plans;
    }
}

