/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlCatalog {
    private final Map<String, Map<String, Table>> schemas = new HashMap<String, Map<String, Table>>();

    public SqlCatalog(List<TableResolver> tableResolvers) {
        HashMap<String, Set> tableConflicts = new HashMap<String, Set>();
        for (TableResolver tableResolver : tableResolvers) {
            List<Table> tables = tableResolver.getTables();
            for (List<String> searchPath : tableResolver.getDefaultSearchPaths()) {
                assert (searchPath.size() == 2 && searchPath.get(0).equals("hazelcast")) : searchPath;
                this.schemas.putIfAbsent(searchPath.get(1), new HashMap());
            }
            for (Table table : tables) {
                String schemaName = table.getSchemaName();
                String tableName = table.getSqlName();
                Table oldTable = this.schemas.computeIfAbsent(schemaName, key -> new HashMap()).putIfAbsent(tableName, table);
                if (oldTable != null) continue;
                tableConflicts.computeIfAbsent(tableName, key -> new HashSet()).add(table);
            }
        }
        for (Set tableConflict : tableConflicts.values()) {
            if (tableConflict.size() == 1) continue;
            HashSet<String> conflictingSchemas = new HashSet<String>(tableConflict.size());
            for (Table table : tableConflict) {
                conflictingSchemas.add(table.getSchemaName());
            }
            for (Table table : tableConflict) {
                table.setConflictingSchemas(conflictingSchemas);
            }
        }
    }

    public Map<String, Map<String, Table>> getSchemas() {
        return this.schemas;
    }
}

