/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.apache.seatunnel.engine.core.dag.actions.Action;

public abstract class AbstractAction
implements Action {
    private String name;
    private transient List<Action> upstreams = new ArrayList<Action>();
    private long id;
    private int parallelism = 1;
    private final Set<URL> jarUrls;

    protected AbstractAction(long id, @NonNull String name, @NonNull List<Action> upstreams, @NonNull Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (upstreams == null) {
            throw new NullPointerException("upstreams is marked @NonNull but is null");
        }
        if (jarUrls == null) {
            throw new NullPointerException("jarUrls is marked @NonNull but is null");
        }
        this.id = id;
        this.name = name;
        this.upstreams = upstreams;
        this.jarUrls = jarUrls;
    }

    protected AbstractAction(long id, @NonNull String name, @NonNull Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (jarUrls == null) {
            throw new NullPointerException("jarUrls is marked @NonNull but is null");
        }
        this.id = id;
        this.name = name;
        this.jarUrls = jarUrls;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
    }

    @Override
    @NonNull
    public List<Action> getUpstream() {
        return this.upstreams;
    }

    @Override
    public void addUpstream(@NonNull Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked @NonNull but is null");
        }
        this.upstreams.add(action);
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Set<URL> getJarUrls() {
        return this.jarUrls;
    }
}

