/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.google.common.collect.Lists;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.PartitionTransformAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.internal.IntermediateQueue;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionEdge;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlan;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalPlan;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.dag.physical.config.IntermediateQueueConfig;
import org.apache.seatunnel.engine.server.dag.physical.config.PartitionConfig;
import org.apache.seatunnel.engine.server.dag.physical.config.SinkConfig;
import org.apache.seatunnel.engine.server.dag.physical.config.SourceConfig;
import org.apache.seatunnel.engine.server.dag.physical.flow.Flow;
import org.apache.seatunnel.engine.server.dag.physical.flow.IntermediateExecutionFlow;
import org.apache.seatunnel.engine.server.dag.physical.flow.PhysicalExecutionFlow;
import org.apache.seatunnel.engine.server.dag.physical.flow.UnknownFlowException;
import org.apache.seatunnel.engine.server.execution.TaskGroupDefaultImpl;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.SinkAggregatedCommitterTask;
import org.apache.seatunnel.engine.server.task.SourceSeaTunnelTask;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.TransformSeaTunnelTask;
import org.apache.seatunnel.engine.server.task.group.TaskGroupWithIntermediateQueue;

public class PhysicalPlanGenerator {
    private final List<Pipeline> pipelines;
    private final IdGenerator idGenerator = new IdGenerator();
    private final JobImmutableInformation jobImmutableInformation;
    private final long initializationTimestamp;
    private final ExecutorService executorService;
    private final NodeEngine nodeEngine;
    private final FlakeIdGenerator flakeIdGenerator;
    private final Map<SourceAction<?, ?, ?>, TaskLocation> enumeratorTaskIDMap = new HashMap();
    private final Map<SinkAction<?, ?, ?, ?>, TaskLocation> committerTaskIDMap = new HashMap();
    private final Set<TaskLocation> pipelineTasks;
    private final Set<TaskLocation> startingTasks;
    private final Map<TaskLocation, Set<Tuple2<Long, Integer>>> subtaskActions;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Object> runningJobStateTimestampsIMap;

    public PhysicalPlanGenerator(@NonNull ExecutionPlan executionPlan, @NonNull NodeEngine nodeEngine, @NonNull JobImmutableInformation jobImmutableInformation, long initializationTimestamp, @NonNull ExecutorService executorService, @NonNull FlakeIdGenerator flakeIdGenerator, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap) {
        if (executionPlan == null) {
            throw new NullPointerException("executionPlan is marked @NonNull but is null");
        }
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (flakeIdGenerator == null) {
            throw new NullPointerException("flakeIdGenerator is marked @NonNull but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked @NonNull but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked @NonNull but is null");
        }
        this.pipelines = executionPlan.getPipelines();
        this.nodeEngine = nodeEngine;
        this.jobImmutableInformation = jobImmutableInformation;
        this.initializationTimestamp = initializationTimestamp;
        this.executorService = executorService;
        this.flakeIdGenerator = flakeIdGenerator;
        this.pipelineTasks = new HashSet<TaskLocation>();
        this.startingTasks = new HashSet<TaskLocation>();
        this.subtaskActions = new HashMap<TaskLocation, Set<Tuple2<Long, Integer>>>();
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
    }

    public Tuple2<PhysicalPlan, Map<Integer, CheckpointPlan>> generate() {
        CopyOnWriteArrayList waitForCompleteBySubPlanList = new CopyOnWriteArrayList();
        HashMap checkpointPlans = new HashMap();
        int totalPipelineNum = this.pipelines.size();
        Stream<SubPlan> subPlanStream = this.pipelines.stream().map(pipeline -> {
            this.pipelineTasks.clear();
            this.startingTasks.clear();
            this.subtaskActions.clear();
            int pipelineId = pipeline.getId();
            List<ExecutionEdge> edges = pipeline.getEdges();
            List<SourceAction<?, ?, ?>> sources = this.findSourceAction(edges);
            List<PhysicalVertex> coordinatorVertexList = this.getEnumeratorTask(sources, pipelineId, totalPipelineNum);
            coordinatorVertexList.addAll(this.getCommitterTask(edges, pipelineId, totalPipelineNum));
            List<PhysicalVertex> physicalVertexList = this.getSourceTask(edges, sources, pipelineId, totalPipelineNum);
            physicalVertexList.addAll(this.getPartitionTask(edges, pipelineId, totalPipelineNum));
            CompletableFuture pipelineFuture = new CompletableFuture();
            waitForCompleteBySubPlanList.add(new PassiveCompletableFuture(pipelineFuture));
            checkpointPlans.put(pipelineId, CheckpointPlan.builder().pipelineId(pipelineId).pipelineSubtasks(this.pipelineTasks).startingSubtasks(this.startingTasks).pipelineActions(pipeline.getActions()).subtaskActions(this.subtaskActions).build());
            return new SubPlan(pipelineId, totalPipelineNum, this.initializationTimestamp, physicalVertexList, coordinatorVertexList, this.jobImmutableInformation, this.executorService, this.runningJobStateIMap, this.runningJobStateTimestampsIMap);
        });
        PhysicalPlan physicalPlan = new PhysicalPlan(subPlanStream.collect(Collectors.toList()), this.executorService, this.jobImmutableInformation, this.initializationTimestamp, this.runningJobStateIMap, this.runningJobStateTimestampsIMap);
        return Tuple2.tuple2(physicalPlan, checkpointPlans);
    }

    private List<SourceAction<?, ?, ?>> findSourceAction(List<ExecutionEdge> edges) {
        return edges.stream().filter(s2 -> s2.getLeftVertex().getAction() instanceof SourceAction).map(s2 -> (SourceAction)s2.getLeftVertex().getAction()).collect(Collectors.toList());
    }

    private List<PhysicalVertex> getCommitterTask(List<ExecutionEdge> edges, int pipelineIndex, int totalPipelineNum) {
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        List collect2 = edges.stream().filter(s2 -> s2.getRightVertex().getAction() instanceof SinkAction).collect(Collectors.toList());
        return collect2.stream().map(s2 -> (SinkAction)s2.getRightVertex().getAction()).map(sinkAction -> {
            Optional sinkAggregatedCommitter;
            try {
                sinkAggregatedCommitter = sinkAction.getSink().createAggregatedCommitter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (sinkAggregatedCommitter.isPresent()) {
                long taskGroupID = this.idGenerator.getNextId();
                long taskTypeId = this.idGenerator.getNextId();
                TaskGroupLocation taskGroupLocation = new TaskGroupLocation(this.jobImmutableInformation.getJobId(), pipelineIndex, taskGroupID);
                TaskLocation taskLocation = new TaskLocation(taskGroupLocation, taskTypeId, 0);
                SinkAggregatedCommitterTask t = new SinkAggregatedCommitterTask(this.jobImmutableInformation.getJobId(), taskLocation, sinkAction, sinkAggregatedCommitter.get());
                this.committerTaskIDMap.put((SinkAction<?, ?, ?, ?>)sinkAction, taskLocation);
                this.pipelineTasks.add(taskLocation);
                this.subtaskActions.put(taskLocation, Collections.singleton(Tuple2.tuple2(sinkAction.getId(), -1)));
                return new PhysicalVertex(atomicInteger.incrementAndGet(), this.executorService, collect2.size(), new TaskGroupDefaultImpl(taskGroupLocation, sinkAction.getName() + "-AggregatedCommitterTask", Lists.newArrayList(t)), this.flakeIdGenerator, pipelineIndex, totalPipelineNum, sinkAction.getJarUrls(), this.jobImmutableInformation, this.initializationTimestamp, this.nodeEngine, this.runningJobStateIMap, this.runningJobStateTimestampsIMap);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<PhysicalVertex> getPartitionTask(List<ExecutionEdge> edges, int pipelineIndex, int totalPipelineNum) {
        return edges.stream().filter(s2 -> s2.getLeftVertex().getAction() instanceof PartitionTransformAction).map(q -> (PartitionTransformAction)q.getLeftVertex().getAction()).map(q -> new PhysicalExecutionFlow((PartitionTransformAction)q, this.getNextWrapper(edges, (Action)q))).flatMap(flow -> {
            ArrayList<PhysicalVertex> t = new ArrayList<PhysicalVertex>();
            long taskIDPrefix = this.idGenerator.getNextId();
            long taskGroupIDPrefix = this.idGenerator.getNextId();
            for (int i = 0; i < flow.getAction().getParallelism(); ++i) {
                long taskGroupID = this.mixIDPrefixAndIndex(taskGroupIDPrefix, i);
                TaskGroupLocation taskGroupLocation = new TaskGroupLocation(this.jobImmutableInformation.getJobId(), pipelineIndex, taskGroupID);
                TaskLocation taskLocation = new TaskLocation(taskGroupLocation, taskIDPrefix, i);
                this.setFlowConfig((Flow)flow, i);
                TransformSeaTunnelTask seaTunnelTask = new TransformSeaTunnelTask(this.jobImmutableInformation.getJobId(), taskLocation, i, (Flow)flow);
                this.fillCheckpointPlan(seaTunnelTask);
                t.add(new PhysicalVertex(i, this.executorService, flow.getAction().getParallelism(), new TaskGroupDefaultImpl(taskGroupLocation, flow.getAction().getName() + "-PartitionTransformTask", Lists.newArrayList(seaTunnelTask)), this.flakeIdGenerator, pipelineIndex, totalPipelineNum, seaTunnelTask.getJarsUrl(), this.jobImmutableInformation, this.initializationTimestamp, this.nodeEngine, this.runningJobStateIMap, this.runningJobStateTimestampsIMap));
            }
            return t.stream();
        }).collect(Collectors.toList());
    }

    private List<PhysicalVertex> getEnumeratorTask(List<SourceAction<?, ?, ?>> sources, int pipelineIndex, int totalPipelineNum) {
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        return sources.stream().map(sourceAction -> {
            long taskGroupID = this.idGenerator.getNextId();
            long taskTypeId = this.idGenerator.getNextId();
            TaskGroupLocation taskGroupLocation = new TaskGroupLocation(this.jobImmutableInformation.getJobId(), pipelineIndex, taskGroupID);
            TaskLocation taskLocation = new TaskLocation(taskGroupLocation, taskTypeId, 0);
            SourceSplitEnumeratorTask t = new SourceSplitEnumeratorTask(this.jobImmutableInformation.getJobId(), taskLocation, sourceAction);
            this.pipelineTasks.add(taskLocation);
            this.startingTasks.add(taskLocation);
            this.subtaskActions.put(taskLocation, Collections.singleton(Tuple2.tuple2(sourceAction.getId(), -1)));
            this.enumeratorTaskIDMap.put((SourceAction<?, ?, ?>)sourceAction, taskLocation);
            return new PhysicalVertex(atomicInteger.incrementAndGet(), this.executorService, sources.size(), new TaskGroupDefaultImpl(taskGroupLocation, sourceAction.getName() + "-SplitEnumerator", Lists.newArrayList(t)), this.flakeIdGenerator, pipelineIndex, totalPipelineNum, t.getJarsUrl(), this.jobImmutableInformation, this.initializationTimestamp, this.nodeEngine, this.runningJobStateIMap, this.runningJobStateTimestampsIMap);
        }).collect(Collectors.toList());
    }

    private List<PhysicalVertex> getSourceTask(List<ExecutionEdge> edges, List<SourceAction<?, ?, ?>> sources, int pipelineIndex, int totalPipelineNum) {
        return sources.stream().map(s2 -> new PhysicalExecutionFlow((SourceAction)s2, this.getNextWrapper(edges, (Action)s2))).flatMap(flow -> {
            ArrayList<PhysicalVertex> t = new ArrayList<PhysicalVertex>();
            ArrayList<PhysicalExecutionFlow> flows = new ArrayList<PhysicalExecutionFlow>(Collections.singletonList(flow));
            if (PhysicalPlanGenerator.sourceWithSink(flow)) {
                flows.addAll(PhysicalPlanGenerator.splitSinkFromFlow(flow));
            }
            long taskGroupIDPrefix = this.idGenerator.getNextId();
            HashMap flowTaskIDPrefixMap = new HashMap();
            for (int i = 0; i < flow.getAction().getParallelism(); ++i) {
                int finalParallelismIndex = i;
                long taskGroupID = this.mixIDPrefixAndIndex(taskGroupIDPrefix, i);
                TaskGroupLocation taskGroupLocation = new TaskGroupLocation(this.jobImmutableInformation.getJobId(), pipelineIndex, taskGroupID);
                List taskList = flows.stream().map(f -> {
                    this.setFlowConfig((Flow)f, finalParallelismIndex);
                    long taskIDPrefix = flowTaskIDPrefixMap.computeIfAbsent(f.getFlowID(), id -> this.idGenerator.getNextId());
                    TaskLocation taskLocation = new TaskLocation(taskGroupLocation, taskIDPrefix, finalParallelismIndex);
                    if (f instanceof PhysicalExecutionFlow) {
                        return new SourceSeaTunnelTask(this.jobImmutableInformation.getJobId(), taskLocation, finalParallelismIndex, (Flow)f);
                    }
                    return new TransformSeaTunnelTask(this.jobImmutableInformation.getJobId(), taskLocation, finalParallelismIndex, (Flow)f);
                }).peek(this::fillCheckpointPlan).collect(Collectors.toList());
                Set<URL> jars = taskList.stream().flatMap(task -> task.getJarsUrl().stream()).collect(Collectors.toSet());
                if (taskList.stream().anyMatch(TransformSeaTunnelTask.class::isInstance)) {
                    t.add(new PhysicalVertex(i, this.executorService, flow.getAction().getParallelism(), new TaskGroupWithIntermediateQueue(taskGroupLocation, flow.getAction().getName() + "-SourceTask", taskList.stream().map(task -> task).collect(Collectors.toList())), this.flakeIdGenerator, pipelineIndex, totalPipelineNum, jars, this.jobImmutableInformation, this.initializationTimestamp, this.nodeEngine, this.runningJobStateIMap, this.runningJobStateTimestampsIMap));
                    continue;
                }
                t.add(new PhysicalVertex(i, this.executorService, flow.getAction().getParallelism(), new TaskGroupDefaultImpl(taskGroupLocation, flow.getAction().getName() + "-SourceTask", taskList.stream().map(task -> task).collect(Collectors.toList())), this.flakeIdGenerator, pipelineIndex, totalPipelineNum, jars, this.jobImmutableInformation, this.initializationTimestamp, this.nodeEngine, this.runningJobStateIMap, this.runningJobStateTimestampsIMap));
            }
            return t.stream();
        }).collect(Collectors.toList());
    }

    private void fillCheckpointPlan(SeaTunnelTask task) {
        this.pipelineTasks.add(task.getTaskLocation());
        this.subtaskActions.put(task.getTaskLocation(), task.getActionIds().stream().map(id -> Tuple2.tuple2(id, task.getTaskLocation().getTaskIndex())).collect(Collectors.toSet()));
    }

    private void setFlowConfig(Flow f, int parallelismIndex) {
        if (f instanceof PhysicalExecutionFlow) {
            PhysicalExecutionFlow flow = (PhysicalExecutionFlow)f;
            if (flow.getAction() instanceof SourceAction) {
                SourceConfig config = new SourceConfig();
                config.setEnumeratorTask(this.enumeratorTaskIDMap.get((SourceAction)flow.getAction()));
                flow.setConfig(config);
            } else if (flow.getAction() instanceof SinkAction) {
                SinkConfig config = new SinkConfig();
                if (this.committerTaskIDMap.containsKey((SinkAction)flow.getAction())) {
                    config.setContainCommitter(true);
                    config.setCommitterTask(this.committerTaskIDMap.get((SinkAction)flow.getAction()));
                }
                flow.setConfig(config);
            } else if (flow.getAction() instanceof PartitionTransformAction) {
                PartitionConfig config = new PartitionConfig(((PartitionTransformAction)flow.getAction()).getPartitionTransformation().getPartitionCount(), ((PartitionTransformAction)flow.getAction()).getPartitionTransformation().getTargetCount(), parallelismIndex);
                flow.setConfig(config);
            }
        } else if (f instanceof IntermediateExecutionFlow) {
            ((IntermediateExecutionFlow)f).setConfig(new IntermediateQueueConfig(((IntermediateExecutionFlow)f).getQueue().getId()));
        } else {
            throw new UnknownFlowException(f);
        }
        if (!f.getNext().isEmpty()) {
            f.getNext().forEach(n -> this.setFlowConfig((Flow)n, parallelismIndex));
        }
    }

    private static List<Flow> splitSinkFromFlow(Flow flow) {
        List<PhysicalExecutionFlow> sinkFlows = flow.getNext().stream().filter(f -> f instanceof PhysicalExecutionFlow).map(f -> (PhysicalExecutionFlow)f).filter(f -> f.getAction() instanceof SinkAction).collect(Collectors.toList());
        ArrayList<Flow> allFlows = new ArrayList<Flow>();
        flow.getNext().removeAll(sinkFlows);
        sinkFlows.forEach(s2 -> {
            IntermediateQueue queue = new IntermediateQueue(s2.getAction().getId(), s2.getAction().getName() + "-Queue", s2.getAction().getParallelism());
            IntermediateExecutionFlow intermediateFlow = new IntermediateExecutionFlow(queue);
            flow.getNext().add(intermediateFlow);
            IntermediateExecutionFlow intermediateFlowQuote = new IntermediateExecutionFlow(queue);
            intermediateFlowQuote.getNext().add((Flow)s2);
            allFlows.add(intermediateFlowQuote);
        });
        if (flow.getNext().size() > sinkFlows.size()) {
            allFlows.addAll(flow.getNext().stream().flatMap(f -> PhysicalPlanGenerator.splitSinkFromFlow(f).stream()).collect(Collectors.toList()));
        }
        return allFlows;
    }

    private static boolean sourceWithSink(PhysicalExecutionFlow<?, ?> flow) {
        return flow.getAction() instanceof SinkAction || flow.getNext().stream().map(f -> (PhysicalExecutionFlow)f).map(PhysicalPlanGenerator::sourceWithSink).collect(Collectors.toList()).contains(true);
    }

    private long mixIDPrefixAndIndex(long idPrefix, int index) {
        return idPrefix * 10000L + (long)index;
    }

    private List<Flow> getNextWrapper(List<ExecutionEdge> edges, Action start) {
        List actions = edges.stream().filter(e -> e.getLeftVertex().getAction().equals(start)).map(e -> e.getRightVertex().getAction()).collect(Collectors.toList());
        List<Flow> wrappers = actions.stream().filter(a -> a instanceof PartitionTransformAction || a instanceof SinkAction).map(PhysicalExecutionFlow::new).collect(Collectors.toList());
        wrappers.addAll(actions.stream().filter(a -> !(a instanceof PartitionTransformAction) && !(a instanceof SinkAction)).map(a -> new PhysicalExecutionFlow((Action)a, this.getNextWrapper(edges, (Action)a))).collect(Collectors.toList()));
        return wrappers;
    }
}

