/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.cluster.Address;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupDefaultImpl;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.task.TaskGroupImmutableInformation;
import org.apache.seatunnel.engine.server.task.operation.CancelTaskOperation;
import org.apache.seatunnel.engine.server.task.operation.DeployTaskOperation;

public class PhysicalVertex {
    private static final ILogger LOGGER = Logger.getLogger(PhysicalVertex.class);
    private final TaskGroupLocation taskGroupLocation;
    private final int subTaskGroupIndex;
    private final String taskFullName;
    private final int parallelism;
    private final TaskGroupDefaultImpl taskGroup;
    private final ExecutorService executorService;
    private final FlakeIdGenerator flakeIdGenerator;
    private final int pipelineId;
    private final int totalPipelineNum;
    private final Set<URL> pluginJarsUrls;
    private final IMap<Object, Object> runningJobStateIMap;
    private CompletableFuture<TaskExecutionState> taskFuture;
    private final IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private final JobImmutableInformation jobImmutableInformation;
    private final long initializationTimestamp;
    private final NodeEngine nodeEngine;
    private TaskGroupImmutableInformation taskGroupImmutableInformation;
    private JobMaster jobMaster;

    public PhysicalVertex(int subTaskGroupIndex, @NonNull ExecutorService executorService, int parallelism, @NonNull TaskGroupDefaultImpl taskGroup, @NonNull FlakeIdGenerator flakeIdGenerator, int pipelineId, int totalPipelineNum, Set<URL> pluginJarsUrls, @NonNull JobImmutableInformation jobImmutableInformation, long initializationTimestamp, @NonNull NodeEngine nodeEngine, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (taskGroup == null) {
            throw new NullPointerException("taskGroup is marked @NonNull but is null");
        }
        if (flakeIdGenerator == null) {
            throw new NullPointerException("flakeIdGenerator is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked @NonNull but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked @NonNull but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked @NonNull but is null");
        }
        this.taskGroupLocation = taskGroup.getTaskGroupLocation();
        this.subTaskGroupIndex = subTaskGroupIndex;
        this.executorService = executorService;
        this.parallelism = parallelism;
        this.taskGroup = taskGroup;
        this.flakeIdGenerator = flakeIdGenerator;
        this.pipelineId = pipelineId;
        this.totalPipelineNum = totalPipelineNum;
        this.pluginJarsUrls = pluginJarsUrls;
        this.jobImmutableInformation = jobImmutableInformation;
        this.initializationTimestamp = initializationTimestamp;
        Long[] stateTimestamps = new Long[ExecutionState.values().length];
        if (runningJobStateTimestampsIMap.get(taskGroup.getTaskGroupLocation()) == null) {
            stateTimestamps[ExecutionState.INITIALIZING.ordinal()] = initializationTimestamp;
            runningJobStateTimestampsIMap.put(taskGroup.getTaskGroupLocation(), stateTimestamps);
        }
        if (runningJobStateIMap.get(this.taskGroupLocation) == null) {
            stateTimestamps[ExecutionState.CREATED.ordinal()] = System.currentTimeMillis();
            runningJobStateTimestampsIMap.put(this.taskGroupLocation, stateTimestamps);
            runningJobStateIMap.put(this.taskGroupLocation, ExecutionState.CREATED);
        }
        this.nodeEngine = nodeEngine;
        this.taskFullName = String.format("Job %s (%s), Pipeline: [(%d/%d)], task: [%s (%d/%d)], taskGroupLocation: [%s]", jobImmutableInformation.getJobConfig().getName(), jobImmutableInformation.getJobId(), pipelineId, totalPipelineNum, taskGroup.getTaskGroupName(), subTaskGroupIndex + 1, parallelism, this.taskGroupLocation);
        this.taskFuture = new CompletableFuture();
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
    }

    public PassiveCompletableFuture<TaskExecutionState> initStateFuture() {
        this.taskFuture = new CompletableFuture();
        ExecutionState executionState = (ExecutionState)this.runningJobStateIMap.get(this.taskGroupLocation);
        if (executionState != null) {
            LOGGER.info(String.format("The task %s is in state %s when init state future", this.taskFullName, executionState));
        }
        if (ExecutionState.CANCELING.equals(executionState)) {
            this.noticeTaskExecutionServiceCancel();
        } else if (executionState.isEndState()) {
            this.taskFuture.complete(new TaskExecutionState(this.taskGroupLocation, executionState, null));
        }
        return new PassiveCompletableFuture<TaskExecutionState>(this.taskFuture);
    }

    private void deployOnLocal(@NonNull SlotProfile slotProfile) {
        if (slotProfile == null) {
            throw new NullPointerException("slotProfile is marked @NonNull but is null");
        }
        this.deployInternal(taskGroupImmutableInformation -> {
            SeaTunnelServer server = (SeaTunnelServer)this.nodeEngine.getService("st:impl:seaTunnelServer");
            server.getSlotService().getSlotContext(slotProfile).getTaskExecutionService().deployTask((TaskGroupImmutableInformation)taskGroupImmutableInformation);
        });
    }

    private void deployOnRemote(@NonNull SlotProfile slotProfile) {
        if (slotProfile == null) {
            throw new NullPointerException("slotProfile is marked @NonNull but is null");
        }
        this.deployInternal(taskGroupImmutableInformation -> {
            try {
                this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new DeployTaskOperation(slotProfile, (Data)this.nodeEngine.getSerializationService().toData(taskGroupImmutableInformation)), slotProfile.getWorker()).invoke().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void deploy(@NonNull SlotProfile slotProfile) {
        if (slotProfile == null) {
            throw new NullPointerException("slotProfile is marked @NonNull but is null");
        }
        try {
            if (slotProfile.getWorker().equals(this.nodeEngine.getThisAddress())) {
                this.deployOnLocal(slotProfile);
            } else {
                this.deployOnRemote(slotProfile);
            }
        }
        catch (Throwable th) {
            this.failedByException(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployInternal(Consumer<TaskGroupImmutableInformation> taskGroupConsumer) {
        TaskGroupImmutableInformation taskGroupImmutableInformation = this.getTaskGroupImmutableInformation();
        PhysicalVertex physicalVertex = this;
        synchronized (physicalVertex) {
            ExecutionState currentState = (ExecutionState)this.runningJobStateIMap.get(this.taskGroupLocation);
            if (ExecutionState.DEPLOYING.equals(currentState)) {
                taskGroupConsumer.accept(taskGroupImmutableInformation);
                this.updateTaskState(ExecutionState.DEPLOYING, ExecutionState.RUNNING);
            }
        }
    }

    private void failedByException(Throwable th) {
        LOGGER.severe(String.format("%s deploy error with Exception: %s", this.taskFullName, ExceptionUtils.getMessage(th)));
        this.turnToEndState(ExecutionState.FAILED);
        this.taskFuture.complete(new TaskExecutionState(this.taskGroupLocation, ExecutionState.FAILED, th));
    }

    private TaskGroupImmutableInformation getTaskGroupImmutableInformation() {
        return new TaskGroupImmutableInformation(this.flakeIdGenerator.newId(), (Data)this.nodeEngine.getSerializationService().toData(this.taskGroup), this.pluginJarsUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean turnToEndState(@NonNull ExecutionState endState) {
        if (endState == null) {
            throw new NullPointerException("endState is marked @NonNull but is null");
        }
        PhysicalVertex physicalVertex = this;
        synchronized (physicalVertex) {
            ExecutionState currentState = (ExecutionState)this.runningJobStateIMap.get(this.taskGroupLocation);
            if (currentState.isEndState()) {
                String message = String.format("Task %s is already in terminal state %s", this.taskFullName, currentState);
                LOGGER.warning(message);
                return false;
            }
            if (!endState.isEndState()) {
                String message = String.format("Turn task %s state to end state need gave a end state, not %s", this.taskFullName, endState);
                LOGGER.warning(message);
                return false;
            }
            this.updateStateTimestamps(endState);
            this.runningJobStateIMap.set(this.taskGroupLocation, endState);
            LOGGER.info(String.format("%s turn to end state %s.", this.taskFullName, endState));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTaskState(@NonNull ExecutionState current, @NonNull ExecutionState targetState) {
        if (current == null) {
            throw new NullPointerException("current is marked @NonNull but is null");
        }
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        PhysicalVertex physicalVertex = this;
        synchronized (physicalVertex) {
            if (current.isEndState()) {
                String message = "Task is trying to leave terminal state " + current;
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (ExecutionState.SCHEDULED.equals(targetState) && !ExecutionState.CREATED.equals(current)) {
                String message = "Only [CREATED] task can turn to [SCHEDULED]" + current;
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (ExecutionState.DEPLOYING.equals(targetState) && !ExecutionState.SCHEDULED.equals(current)) {
                String message = "Only [SCHEDULED] task can turn to [DEPLOYING]" + current;
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (ExecutionState.RUNNING.equals(targetState) && !ExecutionState.DEPLOYING.equals(current)) {
                String message = "Only [DEPLOYING] task can turn to [RUNNING]" + current;
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (current.equals(this.runningJobStateIMap.get(this.taskGroupLocation))) {
                this.updateStateTimestamps(targetState);
                this.runningJobStateIMap.set(this.taskGroupLocation, targetState);
                LOGGER.info(String.format("%s turn from state %s to %s.", this.taskFullName, current, targetState));
                return true;
            }
            return false;
        }
    }

    public TaskGroupDefaultImpl getTaskGroup() {
        return this.taskGroup;
    }

    public void cancel() {
        if (this.updateTaskState(ExecutionState.CREATED, ExecutionState.CANCELED) || this.updateTaskState(ExecutionState.SCHEDULED, ExecutionState.CANCELED) || this.updateTaskState(ExecutionState.DEPLOYING, ExecutionState.CANCELED)) {
            this.taskFuture.complete(new TaskExecutionState(this.taskGroupLocation, ExecutionState.CANCELED, null));
        } else if (this.updateTaskState(ExecutionState.RUNNING, ExecutionState.CANCELING)) {
            this.noticeTaskExecutionServiceCancel();
        }
    }

    private void noticeTaskExecutionServiceCancel() {
        int i = 0;
        while (!this.taskFuture.isDone() && this.nodeEngine.getClusterService().getMember(this.getCurrentExecutionAddress()) != null) {
            try {
                ++i;
                LOGGER.info(String.format("send cancel %s operator to member %s", this.taskFullName, this.getCurrentExecutionAddress()));
                this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new CancelTaskOperation(this.taskGroupLocation), this.getCurrentExecutionAddress()).invoke().get();
                return;
            }
            catch (Exception e) {
                LOGGER.warning(String.format("%s cancel failed with Exception: %s, retry %s", this.getTaskFullName(), ExceptionUtils.getMessage(e), i));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void updateStateTimestamps(@NonNull ExecutionState targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        Long[] stateTimestamps = this.runningJobStateTimestampsIMap.get(this.taskGroupLocation);
        stateTimestamps[targetState.ordinal()] = System.currentTimeMillis();
        this.runningJobStateTimestampsIMap.set(this.taskGroupLocation, stateTimestamps);
    }

    public ExecutionState getExecutionState() {
        return (ExecutionState)this.runningJobStateIMap.get(this.taskGroupLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetExecutionState() {
        PhysicalVertex physicalVertex = this;
        synchronized (physicalVertex) {
            ExecutionState executionState = this.getExecutionState();
            if (!executionState.isEndState()) {
                String message = String.format("%s reset state failed, only end state can be reset, current is %s", this.getTaskFullName(), executionState);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            this.updateStateTimestamps(ExecutionState.CREATED);
            this.runningJobStateIMap.set(this.taskGroupLocation, ExecutionState.CREATED);
        }
    }

    public void reset() {
        this.resetExecutionState();
    }

    public String getTaskFullName() {
        return this.taskFullName;
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        if (!this.turnToEndState(taskExecutionState.getExecutionState())) {
            return;
        }
        if (taskExecutionState.getThrowable() != null) {
            LOGGER.severe(String.format("%s end with state %s and Exception: %s", this.taskFullName, taskExecutionState.getExecutionState(), ExceptionUtils.getMessage(taskExecutionState.getThrowable())));
        } else {
            LOGGER.info(String.format("%s end with state %s", this.taskFullName, taskExecutionState.getExecutionState()));
        }
        this.taskFuture.complete(taskExecutionState);
    }

    public Address getCurrentExecutionAddress() {
        return this.jobMaster.getOwnedSlotProfiles(this.taskGroupLocation).getWorker();
    }

    public TaskGroupLocation getTaskGroupLocation() {
        return this.taskGroupLocation;
    }

    public void setJobMaster(JobMaster jobMaster) {
        this.jobMaster = jobMaster;
    }
}

