/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seatunnel.engine.server.resourcemanager.AbstractResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.NoEnoughResourceException;
import org.apache.seatunnel.engine.server.resourcemanager.opeartion.RequestSlotOperation;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.engine.server.service.slot.SlotAndWorkerProfile;

public class ResourceRequestHandler {
    private static final ILogger LOGGER = Logger.getLogger(ResourceRequestHandler.class);
    private final CompletableFuture<List<SlotProfile>> completableFuture = new CompletableFuture();
    private final ConcurrentMap<Integer, SlotProfile> resultSlotProfiles = new ConcurrentHashMap<Integer, SlotProfile>();
    private final ConcurrentMap<Address, WorkerProfile> registerWorker;
    private final long jobId;
    private final List<ResourceProfile> resourceProfile;
    private final AbstractResourceManager resourceManager;

    public ResourceRequestHandler(long jobId, List<ResourceProfile> resourceProfile, ConcurrentMap<Address, WorkerProfile> registerWorker, AbstractResourceManager resourceManager) {
        this.jobId = jobId;
        this.resourceProfile = resourceProfile;
        this.registerWorker = registerWorker;
        this.resourceManager = resourceManager;
    }

    public CompletableFuture<List<SlotProfile>> request() {
        ArrayList allRequestFuture = new ArrayList();
        for (int i = 0; i < this.resourceProfile.size(); ++i) {
            ResourceProfile r = this.resourceProfile.get(i);
            Optional<WorkerProfile> workerProfile = this.preCheckWorkerResource(r);
            if (!workerProfile.isPresent()) continue;
            CompletableFuture<SlotAndWorkerProfile> internalCompletableFuture = this.singleResourceRequestToMember(i, r, workerProfile.get());
            allRequestFuture.add(internalCompletableFuture);
        }
        this.getAllOfFuture(allRequestFuture).whenComplete(ExceptionUtil.withTryCatch(LOGGER, (unused, error) -> {
            if (error != null) {
                this.completeRequestWithException((Throwable)error);
            }
            if (this.resultSlotProfiles.size() < this.resourceProfile.size()) {
                if (this.resourceManager.supportDynamicWorker()) {
                    this.applyByDynamicWorker();
                } else {
                    this.completeRequestWithException(new NoEnoughResourceException("can't apply resource request: " + this.resourceProfile.get(this.findNullIndexInResultSlotProfiles())));
                }
            }
        }));
        return this.completableFuture;
    }

    private int findNullIndexInResultSlotProfiles() {
        for (int i = 0; i < this.resourceProfile.size(); ++i) {
            if (this.resultSlotProfiles.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    private void completeRequestWithException(Throwable e) {
        this.releaseAllResourceInternal();
        this.completableFuture.completeExceptionally(e);
    }

    private void addSlotToCacheMap(int index, SlotProfile slotProfile) {
        if (null != slotProfile) {
            this.resultSlotProfiles.put(index, slotProfile);
            if (this.resultSlotProfiles.size() == this.resourceProfile.size()) {
                ArrayList value = new ArrayList();
                for (int i = 0; i < this.resultSlotProfiles.size(); ++i) {
                    value.add(this.resultSlotProfiles.get(i));
                }
                this.completableFuture.complete(value);
            }
        }
    }

    private CompletableFuture<SlotAndWorkerProfile> singleResourceRequestToMember(int i, ResourceProfile r, WorkerProfile workerProfile) {
        InvocationFuture future = this.resourceManager.sendToMember(new RequestSlotOperation(this.jobId, r), workerProfile.getAddress());
        return future.whenComplete(ExceptionUtil.withTryCatch(LOGGER, (slotAndWorkerProfile, error) -> {
            if (error != null) {
                throw new RuntimeException((Throwable)error);
            }
            this.resourceManager.heartbeat(slotAndWorkerProfile.getWorkerProfile());
            this.addSlotToCacheMap(i, slotAndWorkerProfile.getSlotProfile());
        }));
    }

    private Optional<WorkerProfile> preCheckWorkerResource(ResourceProfile r) {
        Optional<WorkerProfile> workerProfile = this.registerWorker.values().stream().filter(worker -> Arrays.stream(worker.getUnassignedSlots()).anyMatch(slot -> slot.getResourceProfile().enoughThan(r))).findAny();
        if (!workerProfile.isPresent()) {
            workerProfile = this.registerWorker.values().stream().filter(worker -> worker.getUnassignedResource().enoughThan(r)).findAny();
        }
        return workerProfile;
    }

    private void applyByDynamicWorker() {
        ArrayList<ResourceProfile> needApplyResource = new ArrayList<ResourceProfile>();
        ArrayList<Integer> needApplyIndex = new ArrayList<Integer>();
        for (int i = 0; i < this.resultSlotProfiles.size(); ++i) {
            if (this.resultSlotProfiles.containsKey(i)) continue;
            needApplyResource.add(this.resourceProfile.get(i));
            needApplyIndex.add(i);
        }
        this.resourceManager.findNewWorker(needApplyResource);
        this.resourceManager.applyResources(this.jobId, needApplyResource).whenComplete(ExceptionUtil.withTryCatch(LOGGER, (s2, e) -> {
            if (e != null) {
                this.completeRequestWithException((Throwable)e);
                return;
            }
            for (int i = 0; i < s2.size(); ++i) {
                this.addSlotToCacheMap((Integer)needApplyIndex.get(i), (SlotProfile)s2.get(i));
            }
        }));
    }

    private void releaseAllResourceInternal() {
        LOGGER.warning("apply resource not success, release all already applied resource");
        this.resultSlotProfiles.values().stream().filter(Objects::nonNull).forEach(profile -> this.resourceManager.releaseResource(this.jobId, (SlotProfile)profile));
    }

    private <T> CompletableFuture<T> getAllOfFuture(List<CompletableFuture<T>> allRequestFuture) {
        return CompletableFuture.allOf(allRequestFuture.toArray(new CompletableFuture[0]));
    }
}

