/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.cluster.Address;

public final class AddressCodec {
    private static final int PORT_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private AddressCodec() {
    }

    public static void encode(ClientMessage clientMessage, Address address) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, address.getPort());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, address.getHost());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static Address decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int port = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String host = StringCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createAddress(host, port);
    }
}

