/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.core.io.SerializedString;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSONObjectException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class BeanPropertyWriter {
    public final SerializedString name;
    public final int typeId;
    private final Field _field;
    private final Method _getter;

    public BeanPropertyWriter(int n, String string2, Field field2, Method method) {
        this.typeId = n;
        this.name = new SerializedString(string2);
        if (method == null && field2 == null) {
            throw new IllegalArgumentException("Missing getter and field");
        }
        this._field = field2;
        this._getter = method;
    }

    public BeanPropertyWriter withName(String string2) {
        if (this.name.toString().equals(string2)) {
            return this;
        }
        return new BeanPropertyWriter(this.typeId, string2, this._field, this._getter);
    }

    public Object getValueFor(Object object) throws IOException {
        try {
            if (this._getter == null) {
                return this._field.get(object);
            }
            return this._getter.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            String string2 = this._getter != null ? String.format("method %s.%s()", this._bean(), this._getter.getName()) : String.format("field %s.%s", this._bean(), this._field.getName());
            throw new JSONObjectException(String.format("Failed to access property '%s' (using %s); exception (%s): %s", this.name, exception.getClass().getName(), string2, exception.getMessage()), exception);
        }
    }

    protected String _bean() {
        if (this._getter == null) {
            return this._field.getDeclaringClass().getName();
        }
        return this._getter.getDeclaringClass().getName();
    }
}

