/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class IterationPointer {
    private int index;
    private int size;

    public IterationPointer(int index, int size2) {
        this.index = index;
        this.size = size2;
    }

    public IterationPointer(IterationPointer other) {
        this.index = other.index;
        this.size = other.size;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size2) {
        this.size = size2;
    }

    public static IterationPointer[] decodePointers(List<Map.Entry<Integer, Integer>> pointers) {
        IterationPointer[] decoded = new IterationPointer[pointers.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> pointer : pointers) {
            decoded[i++] = new IterationPointer(pointer.getKey(), pointer.getValue());
        }
        return decoded;
    }

    public static Collection<Map.Entry<Integer, Integer>> encodePointers(IterationPointer[] pointers) {
        ArrayList<Map.Entry<Integer, Integer>> encoded = new ArrayList<Map.Entry<Integer, Integer>>(pointers.length);
        for (IterationPointer pointer : pointers) {
            encoded.add(new AbstractMap.SimpleEntry<Integer, Integer>(pointer.getIndex(), pointer.getSize()));
        }
        return encoded;
    }

    public String toString() {
        return "IterationPointer{index=" + this.index + ", size=" + this.size + '}';
    }
}

