/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.seatunnel.api.table.catalog.TablePath;

public final class TableIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String databaseName;
    private final String tableName;

    private TableIdentifier(String catalogName, String databaseName, String tableName) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public static TableIdentifier of(String catalogName, String databaseName, String tableName) {
        return new TableIdentifier(catalogName, databaseName, tableName);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TablePath toTablePath() {
        return TablePath.of(this.databaseName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableIdentifier that = (TableIdentifier)o;
        return this.catalogName.equals(that.catalogName) && this.databaseName.equals(that.databaseName) && this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.databaseName, this.tableName);
    }

    public String toString() {
        return String.join((CharSequence)".", this.catalogName, this.databaseName, this.tableName);
    }
}

