/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.jvm;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.core.starter.seatunnel.jvm.JavaVersion;
import org.apache.seatunnel.core.starter.seatunnel.jvm.JvmOptionsParserException;

final class JvmOptionsParser {
    private static final Pattern PATTERN = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");

    JvmOptionsParser() {
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected one arguments specifying path to PATH_CONF, but was " + Arrays.toString(args));
        }
        JvmOptionsParser parser = new JvmOptionsParser();
        List<String> jvmOptions = parser.readJvmOptionsFiles(Paths.get(args[0], new String[0]));
        System.out.println(String.join((CharSequence)" ", jvmOptions));
    }

    List<String> readJvmOptionsFiles(Path config) {
        ArrayList<String> jvmOptions = new ArrayList<String>();
        TreeMap invalidLines = new TreeMap();
        try (InputStream is = Files.newInputStream(config, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            JvmOptionsParser.parse(JavaVersion.majorVersion(JavaVersion.CURRENT), br, jvmOptions::add, invalidLines::put);
        }
        if (!invalidLines.isEmpty()) {
            throw new JvmOptionsParserException((SeaTunnelErrorCode)CommonErrorCode.IMPROPERLY_FORMATTED_JVM_OPTION, String.format(Locale.ROOT, "encountered [%d] error%s parsing [%s]", invalidLines.size(), invalidLines.size() == 1 ? "" : "s", config));
        }
        return jvmOptions;
    }

    static void parse(int javaMajorVersion, BufferedReader br, JvmOptionConsumer jvmOptionConsumer, InvalidLineConsumer invalidLineConsumer) {
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            if (line.startsWith("#") || line.matches("\\s*")) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                int upper;
                int lower;
                String start = matcher.group("start");
                String end = matcher.group("end");
                if (start == null) {
                    jvmOptionConsumer.accept(line);
                    continue;
                }
                try {
                    lower = Integer.parseInt(start);
                }
                catch (NumberFormatException e) {
                    invalidLineConsumer.accept(lineNumber, line);
                    continue;
                }
                if (matcher.group("range") == null) {
                    upper = lower;
                } else if (end == null) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(end);
                    }
                    catch (NumberFormatException e) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                    if (upper < lower) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                }
                if (lower > javaMajorVersion || javaMajorVersion > upper) continue;
                jvmOptionConsumer.accept(matcher.group("option"));
                continue;
            }
            invalidLineConsumer.accept(lineNumber, line);
        }
    }

    static interface InvalidLineConsumer {
        public void accept(int var1, String var2);
    }

    static interface JvmOptionConsumer {
        public void accept(String var1);
    }
}

