/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;

@AutoService(value={SeaTunnelTransform.class})
public class SplitTransform
extends MultipleFieldOutputTransform {
    public static final Option<String> KEY_SEPARATOR = Options.key((String)"separator").stringType().noDefaultValue().withDescription("The separator to split the field");
    public static final Option<String> KEY_SPLIT_FIELD = Options.key((String)"split_field").stringType().noDefaultValue().withDescription("The field to be split");
    public static final Option<List<String>> KEY_OUTPUT_FIELDS = Options.key((String)"output_fields").listType().noDefaultValue().withDescription("The result fields after split");
    private String separator;
    private String splitField;
    private int splitFieldIndex;
    private String[] outputFields;
    private String[] emptySplits;

    public String getPluginName() {
        return "Split";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{KEY_SEPARATOR.key(), KEY_SPLIT_FIELD.key(), KEY_OUTPUT_FIELDS.key()});
        if (!checkResult.isSuccess()) {
            throw new IllegalArgumentException("Failed to check config! " + checkResult.getMsg());
        }
        this.separator = pluginConfig.getString(KEY_SEPARATOR.key());
        this.splitField = pluginConfig.getString(KEY_SPLIT_FIELD.key());
        this.outputFields = pluginConfig.getStringList(KEY_OUTPUT_FIELDS.key()).toArray(new String[0]);
        this.emptySplits = new String[this.outputFields.length];
    }

    @Override
    protected void setInputRowType(SeaTunnelRowType rowType) {
        this.splitFieldIndex = rowType.indexOf(this.splitField);
        if (this.splitFieldIndex == -1) {
            throw new IllegalArgumentException("Cannot find [" + this.splitField + "] field in input row type");
        }
    }

    @Override
    protected String[] getOutputFieldNames() {
        return this.outputFields;
    }

    @Override
    protected SeaTunnelDataType[] getOutputFieldDataTypes() {
        return (SeaTunnelDataType[])IntStream.range(0, this.outputFields.length).mapToObj(value -> BasicType.STRING_TYPE).toArray(SeaTunnelDataType[]::new);
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object splitFieldValue = inputRow.getField(this.splitFieldIndex);
        if (splitFieldValue == null) {
            return this.emptySplits;
        }
        Object[] splitFieldValues = splitFieldValue.toString().split(this.separator, this.outputFields.length);
        if (splitFieldValues.length < this.outputFields.length) {
            Object[] tmp = splitFieldValues;
            splitFieldValues = new String[this.outputFields.length];
            System.arraycopy(tmp, 0, splitFieldValues, 0, tmp.length);
        }
        return splitFieldValues;
    }
}

