/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.SeaTunnelRowContainerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleFieldOutputTransform
extends AbstractSeaTunnelTransform {
    private static final Logger log = LoggerFactory.getLogger(MultipleFieldOutputTransform.class);
    private static final String[] TYPE_ARRAY_STRING = new String[0];
    private static final SeaTunnelDataType[] TYPE_ARRAY_SEATUNNEL_DATA_TYPE = new SeaTunnelDataType[0];
    private String[] outputFieldNames;
    private int[] fieldsIndex;
    private SeaTunnelRowContainerGenerator rowContainerGenerator;

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        this.setInputRowType(inputRowType);
        this.outputFieldNames = this.getOutputFieldNames();
        this.fieldsIndex = new int[this.outputFieldNames.length];
        if (this.outputFieldNames.length != new HashSet<String>(Arrays.asList(this.outputFieldNames)).size()) {
            throw new IllegalStateException("Duplicate field names are not allowed. field names: " + this.outputFieldNames);
        }
        SeaTunnelDataType[] outputFieldDataTypes = this.getOutputFieldDataTypes();
        if (this.outputFieldNames.length != outputFieldDataTypes.length) {
            throw new IllegalStateException("Field name and field type count mismatch, field names: " + this.outputFieldNames + ", field types: " + outputFieldDataTypes);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(inputRowType.getFieldNames()));
        ArrayList<SeaTunnelDataType> fieldDataTypes = new ArrayList<SeaTunnelDataType>(Arrays.asList(inputRowType.getFieldTypes()));
        int addFieldCount = 0;
        for (int i = 0; i < this.outputFieldNames.length; ++i) {
            String outputFieldName = this.outputFieldNames[i];
            SeaTunnelDataType outputFieldDataType = outputFieldDataTypes[i];
            int index = fieldNames.indexOf(outputFieldName);
            if (index != -1) {
                if (!outputFieldDataType.equals(fieldDataTypes.get(index))) {
                    fieldDataTypes.set(index, outputFieldDataType);
                }
                this.fieldsIndex[i] = index;
                continue;
            }
            ++addFieldCount;
            fieldNames.add(outputFieldName);
            fieldDataTypes.add(outputFieldDataType);
            this.fieldsIndex[i] = fieldNames.indexOf(outputFieldName);
        }
        if (addFieldCount > 0) {
            final int inputFieldLength = inputRowType.getTotalFields();
            final int outputFieldLength = fieldNames.size();
            this.rowContainerGenerator = new SeaTunnelRowContainerGenerator(){

                @Override
                public SeaTunnelRow apply(SeaTunnelRow inputRow) {
                    Object[] outputFieldValues = new Object[outputFieldLength];
                    System.arraycopy(inputRow.getFields(), 0, outputFieldValues, 0, inputFieldLength);
                    SeaTunnelRow outputRow = new SeaTunnelRow(outputFieldValues);
                    outputRow.setTableId(inputRow.getTableId());
                    outputRow.setRowKind(inputRow.getRowKind());
                    return outputRow;
                }
            };
        } else {
            this.rowContainerGenerator = SeaTunnelRowContainerGenerator.REUSE_ROW;
        }
        SeaTunnelRowType outputRowType = new SeaTunnelRowType(fieldNames.toArray(TYPE_ARRAY_STRING), fieldDataTypes.toArray(TYPE_ARRAY_SEATUNNEL_DATA_TYPE));
        log.info("Changed input row type: {} to output row type: {}", (Object)inputRowType, (Object)outputRowType);
        return outputRowType;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] fieldValues = this.getOutputFieldValues(new SeaTunnelRowAccessor(inputRow));
        SeaTunnelRow outputRow = (SeaTunnelRow)this.rowContainerGenerator.apply(inputRow);
        for (int i = 0; i < this.outputFieldNames.length; ++i) {
            outputRow.setField(this.fieldsIndex[i], fieldValues == null ? null : fieldValues[i]);
        }
        return outputRow;
    }

    protected abstract void setInputRowType(SeaTunnelRowType var1);

    protected abstract String[] getOutputFieldNames();

    protected abstract SeaTunnelDataType[] getOutputFieldDataTypes();

    protected abstract Object[] getOutputFieldValues(SeaTunnelRowAccessor var1);
}

