/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sqlengine.zeta;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sqlengine.zeta.ZetaSQLFunction;

public class ZetaSQLFilter {
    private final ZetaSQLFunction zetaSQLFunction;

    public ZetaSQLFilter(ZetaSQLFunction zetaSQLFunction) {
        this.zetaSQLFunction = zetaSQLFunction;
    }

    public boolean executeFilter(Expression whereExpr, Object[] inputFields) {
        if (whereExpr == null) {
            return true;
        }
        if (whereExpr instanceof Function) {
            return this.functionExpr((Function)whereExpr, inputFields);
        }
        if (whereExpr instanceof IsNullExpression) {
            return this.isNullExpr((IsNullExpression)whereExpr, inputFields);
        }
        if (whereExpr instanceof InExpression) {
            return this.inExpr((InExpression)whereExpr, inputFields);
        }
        if (whereExpr instanceof LikeExpression) {
            return this.likeExpr((LikeExpression)whereExpr, inputFields);
        }
        if (whereExpr instanceof ComparisonOperator) {
            Pair<Object, Object> pair = this.executeComparisonOperator((ComparisonOperator)whereExpr, inputFields);
            if (whereExpr instanceof EqualsTo) {
                return this.equalsToExpr(pair);
            }
            if (whereExpr instanceof NotEqualsTo) {
                return this.notEqualsToExpr(pair);
            }
            if (whereExpr instanceof GreaterThan) {
                return this.greaterThanExpr(pair);
            }
            if (whereExpr instanceof GreaterThanEquals) {
                return this.greaterThanEqualsExpr(pair);
            }
            if (whereExpr instanceof MinorThan) {
                return this.minorThanExpr(pair);
            }
            if (whereExpr instanceof MinorThanEquals) {
                return this.minorThanEqualsExpr(pair);
            }
        }
        if (whereExpr instanceof AndExpression) {
            return this.andExpr((AndExpression)whereExpr, inputFields);
        }
        if (whereExpr instanceof OrExpression) {
            return this.orExpr((OrExpression)whereExpr, inputFields);
        }
        if (whereExpr instanceof Parenthesis) {
            return this.parenthesisExpr((Parenthesis)whereExpr, inputFields);
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported SQL Expression: %s ", whereExpr));
    }

    private boolean functionExpr(Function function, Object[] inputFields) {
        Boolean result = (Boolean)this.zetaSQLFunction.computeForValue(function, inputFields);
        if (result == null) {
            return false;
        }
        return result;
    }

    private boolean isNullExpr(IsNullExpression isNullExpression, Object[] inputFields) {
        Expression leftExpr = isNullExpression.getLeftExpression();
        Object leftVal = this.zetaSQLFunction.computeForValue(leftExpr, inputFields);
        if (isNullExpression.isNot()) {
            return leftVal != null;
        }
        return leftVal == null;
    }

    private boolean inExpr(InExpression inExpression, Object[] inputFields) {
        Expression leftExpr = inExpression.getLeftExpression();
        ExpressionList itemsList = (ExpressionList)inExpression.getRightItemsList();
        Object leftValue = this.zetaSQLFunction.computeForValue(leftExpr, inputFields);
        for (Expression exprItem : itemsList.getExpressions()) {
            Object rightValue = this.zetaSQLFunction.computeForValue(exprItem, inputFields);
            if (leftValue == null && rightValue == null) {
                return true;
            }
            if (leftValue != null) {
                if (!(leftValue instanceof Number && rightValue instanceof Number ? ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue() : leftValue.equals(rightValue))) continue;
                return !inExpression.isNot();
            }
            return false;
        }
        return inExpression.isNot();
    }

    private boolean likeExpr(LikeExpression likeExpression, Object[] inputFields) {
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "Unsupported [LIKE] filter expression yet");
    }

    private Pair<Object, Object> executeComparisonOperator(ComparisonOperator comparisonOperator, Object[] inputFields) {
        Expression leftExpr = comparisonOperator.getLeftExpression();
        Expression rightExpr = comparisonOperator.getRightExpression();
        Object leftVal = this.zetaSQLFunction.computeForValue(leftExpr, inputFields);
        Object rightVal = this.zetaSQLFunction.computeForValue(rightExpr, inputFields);
        return Pair.of((Object)leftVal, (Object)rightVal);
    }

    private boolean equalsToExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() == ((Number)rightVal).doubleValue();
        }
        return leftVal.equals(rightVal);
    }

    private boolean notEqualsToExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null) {
            return rightVal != null;
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() != ((Number)rightVal).doubleValue();
        }
        return !leftVal.equals(rightVal);
    }

    private boolean greaterThanExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() > ((Number)rightVal).doubleValue();
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            return ((String)leftVal).compareTo((String)rightVal) > 0;
        }
        if (leftVal instanceof LocalDateTime && rightVal instanceof LocalDateTime) {
            return ((LocalDateTime)leftVal).isAfter((LocalDateTime)rightVal);
        }
        if (leftVal instanceof LocalDate && rightVal instanceof LocalDate) {
            return ((LocalDate)leftVal).isAfter((LocalDate)rightVal);
        }
        if (leftVal instanceof LocalTime && rightVal instanceof LocalTime) {
            return ((LocalTime)leftVal).isAfter((LocalTime)rightVal);
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Filed types not matched, left is: %s, right is: %s ", leftVal.getClass().getSimpleName(), rightVal.getClass().getSimpleName()));
    }

    private boolean greaterThanEqualsExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() >= ((Number)rightVal).doubleValue();
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            return ((String)leftVal).compareTo((String)rightVal) >= 0;
        }
        if (leftVal instanceof LocalDateTime && rightVal instanceof LocalDateTime) {
            return ((LocalDateTime)leftVal).isAfter((LocalDateTime)rightVal) || ((LocalDateTime)leftVal).isEqual((LocalDateTime)rightVal);
        }
        if (leftVal instanceof LocalDate && rightVal instanceof LocalDate) {
            return ((LocalDate)leftVal).isAfter((LocalDate)rightVal) || ((LocalDate)leftVal).isEqual((LocalDate)rightVal);
        }
        if (leftVal instanceof LocalTime && rightVal instanceof LocalTime) {
            return ((LocalTime)leftVal).isAfter((LocalTime)rightVal) || leftVal.equals(rightVal);
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Filed types not matched, left is: %s, right is: %s ", leftVal.getClass().getSimpleName(), rightVal.getClass().getSimpleName()));
    }

    private boolean minorThanExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof LocalDateTime && rightVal instanceof LocalDateTime) {
            return ((LocalDateTime)leftVal).isBefore((LocalDateTime)rightVal);
        }
        if (leftVal instanceof LocalDate && rightVal instanceof LocalDate) {
            return ((LocalDate)leftVal).isBefore((LocalDate)rightVal);
        }
        if (leftVal instanceof LocalTime && rightVal instanceof LocalTime) {
            return ((LocalTime)leftVal).isBefore((LocalTime)rightVal);
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() < ((Number)rightVal).doubleValue();
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            return ((String)leftVal).compareTo((String)rightVal) < 0;
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Filed types not matched, left is: %s, right is: %s ", leftVal.getClass().getSimpleName(), rightVal.getClass().getSimpleName()));
    }

    private boolean minorThanEqualsExpr(Pair<Object, Object> pair) {
        Object leftVal = pair.getLeft();
        Object rightVal = pair.getRight();
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof LocalDateTime && rightVal instanceof LocalDateTime) {
            return ((LocalDateTime)leftVal).isBefore((LocalDateTime)rightVal) || ((LocalDateTime)leftVal).isEqual((LocalDateTime)rightVal);
        }
        if (leftVal instanceof LocalDate && rightVal instanceof LocalDate) {
            return ((LocalDate)leftVal).isBefore((LocalDate)rightVal) || ((LocalDate)leftVal).isEqual((LocalDate)rightVal);
        }
        if (leftVal instanceof LocalTime && rightVal instanceof LocalTime) {
            return ((LocalTime)leftVal).isBefore((LocalTime)rightVal) || leftVal.equals(rightVal);
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return ((Number)leftVal).doubleValue() <= ((Number)rightVal).doubleValue();
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            return ((String)leftVal).compareTo((String)rightVal) <= 0;
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Filed types not matched, left is: %s, right is: %s ", leftVal.getClass().getSimpleName(), rightVal.getClass().getSimpleName()));
    }

    private boolean andExpr(AndExpression andExpression, Object[] inputFields) {
        Expression leftExpr = andExpression.getLeftExpression();
        boolean leftRes = this.executeFilter(leftExpr, inputFields);
        Expression rightExpr = andExpression.getRightExpression();
        boolean rightRes = this.executeFilter(rightExpr, inputFields);
        return leftRes && rightRes;
    }

    private boolean orExpr(OrExpression orExpression, Object[] inputFields) {
        Expression leftExpr = orExpression.getLeftExpression();
        boolean leftRes = this.executeFilter(leftExpr, inputFields);
        Expression rightExpr = orExpression.getRightExpression();
        boolean rightRes = this.executeFilter(rightExpr, inputFields);
        return leftRes || rightRes;
    }

    private boolean parenthesisExpr(Parenthesis parenthesis, Object[] inputFields) {
        Expression expression = parenthesis.getExpression();
        return this.executeFilter(expression, inputFields);
    }
}

