/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.flakeidgen.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.flakeidgen.impl.AutoBatcher;
import com.hazelcast.flakeidgen.impl.FlakeIdGeneratorService;
import com.hazelcast.flakeidgen.impl.IdBatch;
import com.hazelcast.flakeidgen.impl.NewIdBatchOperation;
import com.hazelcast.flakeidgen.impl.NodeIdOutOfRangeException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class FlakeIdGeneratorProxy
extends AbstractDistributedObject<FlakeIdGeneratorService>
implements FlakeIdGenerator {
    static final long NODE_ID_UPDATE_INTERVAL_NS = TimeUnit.SECONDS.toNanos(2L);
    private static final int NODE_ID_NOT_YET_SET = -1;
    private static final int NODE_ID_OUT_OF_RANGE = -2;
    private static final int MAX_BIT_LENGTH = 63;
    private final String name;
    private final UUID source;
    private final long epochStart;
    private final long nodeIdOffset;
    private final int bitsTimestamp;
    private final int bitsSequence;
    private final int bitsNodeId;
    private final long allowedFutureMillis;
    private volatile int nodeId = -1;
    private volatile long nextNodeIdUpdate = Long.MIN_VALUE;
    private final long increment;
    private final ILogger logger;
    private final AtomicLong generatedValue = new AtomicLong(Long.MIN_VALUE);
    private volatile Member randomMember;
    private AutoBatcher batcher;
    private final Set<UUID> outOfRangeMembers = Collections.newSetFromMap(new ConcurrentHashMap());

    FlakeIdGeneratorProxy(String name, NodeEngine nodeEngine, FlakeIdGeneratorService service, UUID source) {
        super(nodeEngine, service);
        this.name = name;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.source = source;
        FlakeIdGeneratorConfig config = nodeEngine.getConfig().findFlakeIdGeneratorConfig(this.getName());
        this.bitsSequence = config.getBitsSequence();
        this.bitsNodeId = config.getBitsNodeId();
        this.bitsTimestamp = 63 - (this.bitsSequence + this.bitsNodeId);
        Preconditions.checkTrue(this.bitsTimestamp >= 0, "Configuration error, no bits left for the timestamp");
        this.allowedFutureMillis = config.getAllowedFutureMillis();
        this.increment = 1 << this.bitsNodeId;
        this.epochStart = config.getEpochStart();
        this.nodeIdOffset = config.getNodeIdOffset();
        this.batcher = new AutoBatcher(config.getPrefetchCount(), config.getPrefetchValidityMillis(), new AutoBatcher.IdBatchSupplier(){

            @Override
            public IdBatch newIdBatch(int batchSize) {
                IdBatchAndWaitTime result2 = FlakeIdGeneratorProxy.this.newIdBatch(batchSize);
                if (result2.waitTimeMillis > 0L) {
                    try {
                        Thread.sleep(result2.waitTimeMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ExceptionUtil.rethrow(e);
                    }
                }
                return result2.idBatch;
            }
        });
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Created FlakeIdGeneratorProxy, name='" + name + "'");
        }
    }

    @Override
    public long newId() {
        return this.batcher.newId();
    }

    public IdBatchAndWaitTime newIdBatch(int batchSize) {
        int nodeId = this.getNodeId();
        if (nodeId >= 0) {
            return this.newIdBaseLocal(Clock.currentTimeMillis(), nodeId, batchSize);
        }
        while (true) {
            NewIdBatchOperation op = new NewIdBatchOperation(this.name, batchSize);
            op.setCallerUuid(this.source);
            Member target = this.getRandomMember();
            InvocationFuture future = this.getNodeEngine().getOperationService().invokeOnTarget(this.getServiceName(), op, target.getAddress());
            try {
                long base = (Long)future.joinInternal();
                return new IdBatchAndWaitTime(new IdBatch(base, this.increment, batchSize), 0L);
            }
            catch (NodeIdOutOfRangeException e) {
                this.outOfRangeMembers.add(target.getUuid());
                this.randomMember = null;
                continue;
            }
            break;
        }
    }

    IdBatchAndWaitTime newIdBaseLocal(int batchSize) {
        return this.newIdBaseLocal(Clock.currentTimeMillis(), this.getNodeId(), batchSize);
    }

    IdBatchAndWaitTime newIdBaseLocal(long now, int nodeId, int batchSize) {
        long base;
        long oldGeneratedValue;
        Preconditions.checkPositive(batchSize, "batchSize");
        if (nodeId == -2) {
            throw new NodeIdOutOfRangeException("NodeID overflow, this member cannot generate IDs");
        }
        assert ((nodeId & -1 << this.bitsNodeId) == 0) : "nodeId out of range: " + nodeId;
        if ((now -= this.epochStart) < -(1L << this.bitsTimestamp) || now >= 1L << this.bitsTimestamp) {
            throw new HazelcastException("Current time out of allowed range");
        }
        now <<= this.bitsSequence;
        while (!this.generatedValue.compareAndSet(oldGeneratedValue = this.generatedValue.get(), (base = Math.max(now, oldGeneratedValue)) + (long)batchSize)) {
        }
        long waitTime = Math.max(0L, (base + (long)batchSize - now >> this.bitsSequence) - this.allowedFutureMillis);
        base = base << this.bitsNodeId | (long)nodeId;
        ((FlakeIdGeneratorService)this.getService()).updateStatsForBatch(this.name, batchSize);
        return new IdBatchAndWaitTime(new IdBatch(base, this.increment, batchSize), waitTime);
    }

    private int getNodeId() {
        int nodeId = this.getNodeId(System.nanoTime());
        assert (nodeId > 0 || nodeId == -2) : "getNodeId() returned invalid value: " + nodeId;
        return nodeId;
    }

    int getNodeId(long nanoTime) {
        long localNextNodeIdUpdate = this.nextNodeIdUpdate;
        int localNodeId = this.nodeId;
        if (localNextNodeIdUpdate <= nanoTime) {
            if (localNodeId == -2) {
                return localNodeId;
            }
            int newNodeId = this.getNodeEngine().getClusterService().getMemberListJoinVersion();
            assert (newNodeId >= 0) : "newNodeId=" + newNodeId;
            if ((newNodeId = (int)((long)newNodeId + this.nodeIdOffset)) != localNodeId) {
                localNodeId = newNodeId;
                if ((localNodeId & -1 << this.bitsNodeId) != 0) {
                    this.outOfRangeMembers.add(this.getNodeEngine().getClusterService().getLocalMember().getUuid());
                    this.logger.severe("Node ID is out of range (" + localNodeId + "), this member won't be able to generate IDs. Cluster restart is recommended.");
                    localNodeId = -2;
                }
                this.nodeId = localNodeId;
                this.nextNodeIdUpdate = nanoTime + NODE_ID_UPDATE_INTERVAL_NS;
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Node ID assigned to '" + this.name + "': " + localNodeId);
                }
            }
        }
        return localNodeId;
    }

    private Member getRandomMember() {
        Member member = this.randomMember;
        if (member == null) {
            Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
            ArrayList<Member> filteredMembers = new ArrayList<Member>(members.size());
            for (Member m3 : members) {
                if (this.outOfRangeMembers.contains(m3.getUuid())) continue;
                filteredMembers.add(m3);
            }
            if (filteredMembers.isEmpty()) {
                throw new HazelcastException("All members have node ID out of range. Cluster restart is required");
            }
            this.randomMember = member = (Member)filteredMembers.get(ThreadLocalRandomProvider.get().nextInt(filteredMembers.size()));
        }
        return member;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:flakeIdGeneratorService";
    }

    public static class IdBatchAndWaitTime {
        public final IdBatch idBatch;
        public final long waitTimeMillis;

        IdBatchAndWaitTime(IdBatch idBatch, long waitTimeMillis) {
            this.idBatch = idBatch;
            this.waitTimeMillis = waitTimeMillis;
        }
    }
}

