/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableReader;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableWriter;
import com.hazelcast.internal.serialization.impl.portable.MorphingPortableReader;
import com.hazelcast.internal.serialization.impl.portable.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableInternalGenericRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PortableSerializer
implements StreamSerializer<Object> {
    private final PortableContextImpl context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    public PortableSerializer(PortableContextImpl context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return -1;
    }

    @Override
    public void write(ObjectDataOutput out, Object o) throws IOException {
        if (o instanceof Portable) {
            Portable p = (Portable)o;
            if (!(out instanceof BufferObjectDataOutput)) {
                throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
            }
            if (p.getClassId() == 0) {
                throw new IllegalArgumentException("Portable class ID cannot be zero!");
            }
            out.writeInt(p.getFactoryId());
            out.writeInt(p.getClassId());
            this.writeInternal((BufferObjectDataOutput)out, p);
            return;
        }
        if (o instanceof PortableGenericRecord) {
            this.writePortableGenericRecord(out, (PortableGenericRecord)o);
            return;
        }
        throw new IllegalArgumentException("PortableSerializer can only write Portable and PortableGenericRecord");
    }

    void writeInternal(BufferObjectDataOutput out, Portable p) throws IOException {
        ClassDefinition cd2 = this.context.lookupOrRegisterClassDefinition(p);
        out.writeInt(cd2.getVersion());
        DefaultPortableWriter writer = new DefaultPortableWriter(this, out, cd2);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        int factoryId = in.readInt();
        int classId = in.readInt();
        BufferObjectDataInput input2 = (BufferObjectDataInput)in;
        return this.read(input2, factoryId, classId);
    }

    private int findPortableVersion(int factoryId, int classId, Portable portable) {
        int currentVersion = this.context.getClassVersion(factoryId, classId);
        if (currentVersion < 0 && (currentVersion = SerializationUtil.getPortableVersion(portable, this.context.getVersion())) > 0) {
            this.context.setClassVersion(factoryId, classId, currentVersion);
        }
        return currentVersion;
    }

    private Portable createNewPortableInstance(int factoryId, int classId) {
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            return null;
        }
        return portableFactory.create(classId);
    }

    public InternalGenericRecord readAsInternalGenericRecord(ObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        BufferObjectDataInput input2 = (BufferObjectDataInput)in;
        ClassDefinition cd2 = this.setupPositionAndDefinition(input2, factoryId, classId, version);
        return new PortableInternalGenericRecord(this, input2, cd2, true);
    }

    DefaultPortableReader createMorphingReader(BufferObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        int portableVersion = this.findPortableVersion(factoryId, classId, portable);
        return this.createReader(in, factoryId, classId, version, portableVersion);
    }

    public ClassDefinition setupPositionAndDefinition(BufferObjectDataInput in, int factoryId, int classId, int version) throws IOException {
        ClassDefinition cd2;
        int effectiveVersion = version;
        if (effectiveVersion < 0) {
            effectiveVersion = this.context.getVersion();
        }
        if ((cd2 = this.context.lookupClassDefinition(factoryId, classId, effectiveVersion)) == null) {
            int begin = in.position();
            cd2 = this.context.readClassDefinition(in, factoryId, classId, effectiveVersion);
            in.position(begin);
        }
        return cd2;
    }

    public DefaultPortableReader createReader(BufferObjectDataInput in, int factoryId, int classId, int version, int portableVersion) throws IOException {
        ClassDefinition cd2 = this.setupPositionAndDefinition(in, factoryId, classId, version);
        DefaultPortableReader reader = portableVersion == cd2.getVersion() ? new DefaultPortableReader(this, in, cd2) : new MorphingPortableReader(this, in, cd2);
        return reader;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    private void writePortableGenericRecord(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition cd2 = record.getClassDefinition();
        out.writeInt(cd2.getFactoryId());
        out.writeInt(cd2.getClassId());
        this.writePortableGenericRecordInternal(out, record);
    }

    void writePortableGenericRecordInternal(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition cd2 = record.getClassDefinition();
        this.context.registerClassDefinition(cd2, this.context.shouldCheckClassDefinitionErrors());
        out.writeInt(cd2.getVersion());
        BufferObjectDataOutput output = (BufferObjectDataOutput)out;
        DefaultPortableWriter writer = new DefaultPortableWriter(this, output, cd2);
        Set<String> fieldNames = cd2.getFieldNames();
        block32: for (String fieldName : fieldNames) {
            switch (cd2.getFieldType(fieldName)) {
                case PORTABLE: {
                    writer.writeGenericRecord(fieldName, record.getGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE: {
                    writer.writeByte(fieldName, record.getInt8(fieldName));
                    continue block32;
                }
                case BOOLEAN: {
                    writer.writeBoolean(fieldName, record.getBoolean(fieldName));
                    continue block32;
                }
                case CHAR: {
                    writer.writeChar(fieldName, record.getChar(fieldName));
                    continue block32;
                }
                case SHORT: {
                    writer.writeShort(fieldName, record.getInt16(fieldName));
                    continue block32;
                }
                case INT: {
                    writer.writeInt(fieldName, record.getInt32(fieldName));
                    continue block32;
                }
                case LONG: {
                    writer.writeLong(fieldName, record.getInt64(fieldName));
                    continue block32;
                }
                case FLOAT: {
                    writer.writeFloat(fieldName, record.getFloat32(fieldName));
                    continue block32;
                }
                case DOUBLE: {
                    writer.writeDouble(fieldName, record.getFloat64(fieldName));
                    continue block32;
                }
                case UTF: {
                    writer.writeString(fieldName, record.getString(fieldName));
                    continue block32;
                }
                case DECIMAL: {
                    writer.writeDecimal(fieldName, record.getDecimal(fieldName));
                    continue block32;
                }
                case TIME: {
                    writer.writeTime(fieldName, record.getTime(fieldName));
                    continue block32;
                }
                case DATE: {
                    writer.writeDate(fieldName, record.getDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP: {
                    writer.writeTimestamp(fieldName, record.getTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    writer.writeTimestampWithTimezone(fieldName, record.getTimestampWithTimezone(fieldName));
                    continue block32;
                }
                case PORTABLE_ARRAY: {
                    writer.writeGenericRecordArray(fieldName, record.getArrayOfGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE_ARRAY: {
                    writer.writeByteArray(fieldName, record.getArrayOfInt8(fieldName));
                    continue block32;
                }
                case BOOLEAN_ARRAY: {
                    writer.writeBooleanArray(fieldName, record.getArrayOfBoolean(fieldName));
                    continue block32;
                }
                case CHAR_ARRAY: {
                    writer.writeCharArray(fieldName, record.getArrayOfChar(fieldName));
                    continue block32;
                }
                case SHORT_ARRAY: {
                    writer.writeShortArray(fieldName, record.getArrayOfInt16(fieldName));
                    continue block32;
                }
                case INT_ARRAY: {
                    writer.writeIntArray(fieldName, record.getArrayOfInt32(fieldName));
                    continue block32;
                }
                case LONG_ARRAY: {
                    writer.writeLongArray(fieldName, record.getArrayOfInt64(fieldName));
                    continue block32;
                }
                case FLOAT_ARRAY: {
                    writer.writeFloatArray(fieldName, record.getArrayOfFloat32(fieldName));
                    continue block32;
                }
                case DOUBLE_ARRAY: {
                    writer.writeDoubleArray(fieldName, record.getArrayOfFloat64(fieldName));
                    continue block32;
                }
                case UTF_ARRAY: {
                    writer.writeStringArray(fieldName, record.getArrayOfString(fieldName));
                    continue block32;
                }
                case DECIMAL_ARRAY: {
                    writer.writeDecimalArray(fieldName, record.getArrayOfDecimal(fieldName));
                    continue block32;
                }
                case TIME_ARRAY: {
                    writer.writeTimeArray(fieldName, record.getArrayOfTime(fieldName));
                    continue block32;
                }
                case DATE_ARRAY: {
                    writer.writeDateArray(fieldName, record.getArrayOfDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP_ARRAY: {
                    writer.writeTimestampArray(fieldName, record.getArrayOfTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                    writer.writeTimestampWithTimezoneArray(fieldName, record.getArrayOfTimestampWithTimezone(fieldName));
                    continue block32;
                }
            }
            throw new IllegalStateException("Unexpected field type: " + (Object)((Object)cd2.getFieldType(fieldName)));
        }
        writer.end();
    }

    <T> T read(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        if (portable != null) {
            int writeVersion = in.readInt();
            int readVersion = this.findPortableVersion(factoryId, classId, portable);
            DefaultPortableReader reader = this.createReader(in, factoryId, classId, writeVersion, readVersion);
            portable.readPortable(reader);
            reader.end();
            ManagedContext managedContext = this.context.getManagedContext();
            return (T)(managedContext != null ? managedContext.initialize(portable) : portable);
        }
        GenericRecord genericRecord = (GenericRecord)this.readPortableGenericRecord(in, factoryId, classId);
        assert (genericRecord instanceof PortableGenericRecord);
        return (T)genericRecord;
    }

    <T> T readAsGenericRecord(BufferObjectDataInput in, int factoryId, int classId, boolean readGenericLazy) throws IOException {
        if (readGenericLazy) {
            int version = in.readInt();
            ClassDefinition cd2 = this.setupPositionAndDefinition(in, factoryId, classId, version);
            PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd2, true);
            return (T)reader;
        }
        return this.readPortableGenericRecord(in, factoryId, classId);
    }

    private <T> T readPortableGenericRecord(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        int version = in.readInt();
        ClassDefinition cd2 = this.setupPositionAndDefinition(in, factoryId, classId, version);
        PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd2, false);
        GenericRecordBuilder genericRecordBuilder = GenericRecordBuilder.portable(cd2);
        block32: for (String fieldName : cd2.getFieldNames()) {
            switch (cd2.getFieldType(fieldName)) {
                case PORTABLE: {
                    genericRecordBuilder.setGenericRecord(fieldName, reader.getGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE: {
                    genericRecordBuilder.setInt8(fieldName, reader.getInt8(fieldName));
                    continue block32;
                }
                case BOOLEAN: {
                    genericRecordBuilder.setBoolean(fieldName, reader.getBoolean(fieldName));
                    continue block32;
                }
                case CHAR: {
                    genericRecordBuilder.setChar(fieldName, reader.getChar(fieldName));
                    continue block32;
                }
                case SHORT: {
                    genericRecordBuilder.setInt16(fieldName, reader.getInt16(fieldName));
                    continue block32;
                }
                case INT: {
                    genericRecordBuilder.setInt32(fieldName, reader.getInt32(fieldName));
                    continue block32;
                }
                case LONG: {
                    genericRecordBuilder.setInt64(fieldName, reader.getInt64(fieldName));
                    continue block32;
                }
                case FLOAT: {
                    genericRecordBuilder.setFloat32(fieldName, reader.getFloat32(fieldName));
                    continue block32;
                }
                case DOUBLE: {
                    genericRecordBuilder.setFloat64(fieldName, reader.getFloat64(fieldName));
                    continue block32;
                }
                case UTF: {
                    genericRecordBuilder.setString(fieldName, reader.getString(fieldName));
                    continue block32;
                }
                case DECIMAL: {
                    genericRecordBuilder.setDecimal(fieldName, reader.getDecimal(fieldName));
                    continue block32;
                }
                case TIME: {
                    genericRecordBuilder.setTime(fieldName, reader.getTime(fieldName));
                    continue block32;
                }
                case DATE: {
                    genericRecordBuilder.setDate(fieldName, reader.getDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP: {
                    genericRecordBuilder.setTimestamp(fieldName, reader.getTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    genericRecordBuilder.setTimestampWithTimezone(fieldName, reader.getTimestampWithTimezone(fieldName));
                    continue block32;
                }
                case PORTABLE_ARRAY: {
                    genericRecordBuilder.setArrayOfGenericRecord(fieldName, reader.getArrayOfGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE_ARRAY: {
                    genericRecordBuilder.setArrayOfInt8(fieldName, reader.getArrayOfInt8(fieldName));
                    continue block32;
                }
                case BOOLEAN_ARRAY: {
                    genericRecordBuilder.setArrayOfBoolean(fieldName, reader.getArrayOfBoolean(fieldName));
                    continue block32;
                }
                case CHAR_ARRAY: {
                    genericRecordBuilder.setArrayOfChar(fieldName, reader.getArrayOfChar(fieldName));
                    continue block32;
                }
                case SHORT_ARRAY: {
                    genericRecordBuilder.setArrayOfInt16(fieldName, reader.getArrayOfInt16(fieldName));
                    continue block32;
                }
                case INT_ARRAY: {
                    genericRecordBuilder.setArrayOfInt32(fieldName, reader.getArrayOfInt32(fieldName));
                    continue block32;
                }
                case LONG_ARRAY: {
                    genericRecordBuilder.setArrayOfInt64(fieldName, reader.getArrayOfInt64(fieldName));
                    continue block32;
                }
                case FLOAT_ARRAY: {
                    genericRecordBuilder.setArrayOfFloat32(fieldName, reader.getArrayOfFloat32(fieldName));
                    continue block32;
                }
                case DOUBLE_ARRAY: {
                    genericRecordBuilder.setArrayOfFloat64(fieldName, reader.getArrayOfFloat64(fieldName));
                    continue block32;
                }
                case UTF_ARRAY: {
                    genericRecordBuilder.setArrayOfString(fieldName, reader.getArrayOfString(fieldName));
                    continue block32;
                }
                case DECIMAL_ARRAY: {
                    genericRecordBuilder.setArrayOfDecimal(fieldName, reader.getArrayOfDecimal(fieldName));
                    continue block32;
                }
                case TIME_ARRAY: {
                    genericRecordBuilder.setArrayOfTime(fieldName, reader.getArrayOfTime(fieldName));
                    continue block32;
                }
                case DATE_ARRAY: {
                    genericRecordBuilder.setArrayOfDate(fieldName, reader.getArrayOfDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP_ARRAY: {
                    genericRecordBuilder.setArrayOfTimestamp(fieldName, reader.getArrayOfTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                    genericRecordBuilder.setArrayOfTimestampWithTimezone(fieldName, reader.getArrayOfTimestampWithTimezone(fieldName));
                    continue block32;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)cd2.getFieldType(fieldName)));
        }
        reader.end();
        return (T)genericRecordBuilder.build();
    }
}

