/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.FilterWriter;
import java.io.Writer;
import org.apache.log4j.spi.ErrorHandler;

public class QuietWriter
extends FilterWriter {
    protected ErrorHandler errorHandler;

    public QuietWriter(Writer writer, ErrorHandler errorHandler) {
        super(writer);
        this.setErrorHandler(errorHandler);
    }

    @Override
    public void write(String string2) {
        if (string2 != null) {
            try {
                this.out.write(string2);
            }
            catch (Exception e) {
                this.errorHandler.error("Failed to write [" + string2 + "].", e, 1);
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (Exception e) {
            this.errorHandler.error("Failed to flush writer,", e, 2);
        }
    }

    public void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            throw new IllegalArgumentException("Attempted to set null ErrorHandler.");
        }
        this.errorHandler = eh;
    }
}

