/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.factory.Factory;

public interface Catalog
extends AutoCloseable {
    default public Optional<Factory> getFactory() {
        return Optional.empty();
    }

    public void open() throws CatalogException;

    @Override
    public void close() throws CatalogException;

    public String getDefaultDatabase() throws CatalogException;

    public boolean databaseExists(String var1) throws CatalogException;

    public List<String> listDatabases() throws CatalogException;

    public List<String> listTables(String var1) throws CatalogException, DatabaseNotExistException;

    public boolean tableExists(TablePath var1) throws CatalogException;

    public CatalogTable getTable(TablePath var1) throws CatalogException, TableNotExistException;

    default public List<CatalogTable> getTables(ReadonlyConfig config) throws CatalogException {
        List<String> tableNames = config.get(CatalogOptions.TABLE_NAMES);
        ArrayList<CatalogTable> catalogTables = new ArrayList<CatalogTable>();
        if (tableNames != null && tableNames.size() >= 1) {
            for (String tableName : tableNames) {
                TablePath tablePath = TablePath.of(tableName);
                if (!this.tableExists(tablePath)) continue;
                catalogTables.add(this.getTable(tablePath));
            }
            return catalogTables;
        }
        String tablePatternStr = config.get(CatalogOptions.TABLE_PATTERN);
        if (StringUtils.isBlank(tablePatternStr)) {
            return Collections.emptyList();
        }
        Pattern databasePattern = Pattern.compile(config.get(CatalogOptions.DATABASE_PATTERN));
        Pattern tablePattern = Pattern.compile(config.get(CatalogOptions.TABLE_PATTERN));
        List<String> allDatabase = this.listDatabases();
        allDatabase.removeIf(s2 -> !databasePattern.matcher((CharSequence)s2).matches());
        for (String databaseName : allDatabase) {
            tableNames = this.listTables(databaseName);
            for (String tableName : tableNames) {
                if (!tablePattern.matcher(databaseName + "." + tableName).matches()) continue;
                catalogTables.add(this.getTable(TablePath.of(databaseName, tableName)));
            }
        }
        return catalogTables;
    }

    public void createTable(TablePath var1, CatalogTable var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException;

    public void dropTable(TablePath var1, boolean var2) throws TableNotExistException, CatalogException;

    public void createDatabase(TablePath var1, boolean var2) throws DatabaseAlreadyExistException, CatalogException;

    public void dropDatabase(TablePath var1, boolean var2) throws DatabaseNotExistException, CatalogException;
}

