/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ConfigAdapter;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigAdapterUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigAdapterUtils.class);
    private static final List<ConfigAdapter> CONFIG_ADAPTERS = new ArrayList<ConfigAdapter>(0);

    public static Optional<ConfigAdapter> selectAdapter(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        for (ConfigAdapter configAdapter : CONFIG_ADAPTERS) {
            String extension2 = FileUtils.getFileExtension(filePath);
            for (String extensionIdentifier : ArrayUtils.nullToEmpty(configAdapter.extensionIdentifiers())) {
                if (!StringUtils.equalsIgnoreCase(extension2, extensionIdentifier)) continue;
                return Optional.of(configAdapter);
            }
        }
        return Optional.empty();
    }

    public static Optional<ConfigAdapter> selectAdapter(@NonNull Path filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return ConfigAdapterUtils.selectAdapter(filePath.getFileName().toString());
    }

    static {
        ServiceLoader<ConfigAdapter> serviceLoader = ServiceLoader.load(ConfigAdapter.class);
        Iterator<ConfigAdapter> it = serviceLoader.iterator();
        it.forEachRemaining(CONFIG_ADAPTERS::add);
    }
}

