/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.core.dag.actions.ActionUtils;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.Edge;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.VertexInfo;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlanGenerator;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;

public class DAGUtils {
    public static JobDAGInfo getJobDAGInfo(LogicalDag logicalDag, JobImmutableInformation jobImmutableInformation, CheckpointConfig checkpointConfig, boolean isPhysicalDAGIInfo) {
        List<Pipeline> pipelines = new ExecutionPlanGenerator(logicalDag, jobImmutableInformation, checkpointConfig).generate().getPipelines();
        if (isPhysicalDAGIInfo) {
            HashMap<Integer, List<Edge>> pipelineWithEdges = new HashMap<Integer, List<Edge>>();
            HashMap<Long, VertexInfo> vertexInfoMap = new HashMap<Long, VertexInfo>();
            pipelines.forEach(pipeline -> {
                pipelineWithEdges.put(pipeline.getId(), pipeline.getEdges().stream().map(e -> new Edge(e.getLeftVertexId(), e.getRightVertexId())).collect(Collectors.toList()));
                pipeline.getVertexes().forEach((id, vertex) -> vertexInfoMap.put((Long)id, new VertexInfo(vertex.getVertexId(), ActionUtils.getActionType(vertex.getAction()), vertex.getAction().getName())));
            });
            return new JobDAGInfo(jobImmutableInformation.getJobId(), pipelineWithEdges, vertexInfoMap);
        }
        List edges = logicalDag.getEdges().stream().map(e -> new Edge(e.getInputVertexId(), e.getTargetVertexId())).collect(Collectors.toList());
        Map<Long, LogicalVertex> logicalVertexMap = logicalDag.getLogicalVertexMap();
        Map<Long, VertexInfo> vertexInfoMap = logicalVertexMap.values().stream().map(v -> new VertexInfo(v.getVertexId(), ActionUtils.getActionType(v.getAction()), v.getAction().getName())).collect(Collectors.toMap(VertexInfo::getVertexId, Function.identity()));
        Map<Integer, List<Edge>> pipelineWithEdges = edges.stream().collect(Collectors.groupingBy(e -> {
            LogicalVertex info = (LogicalVertex)logicalVertexMap.get(e.getInputVertexId() != null ? e.getInputVertexId() : e.getTargetVertexId());
            return pipelines.stream().filter(p -> p.getActions().containsKey(info.getAction().getId())).findFirst().get().getId();
        }, Collectors.toList()));
        return new JobDAGInfo(jobImmutableInformation.getJobId(), pipelineWithEdges, vertexInfoMap);
    }
}

