/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SimpleEntryViewCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.SimpleEntryView;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class MapGetEntryViewCodec {
    public static final int REQUEST_MESSAGE_TYPE = 72960;
    public static final int RESPONSE_MESSAGE_TYPE = 72961;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_MAX_IDLE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 21;

    private MapGetEntryViewCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, long threadId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Map.GetEntryView");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72960);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, threadId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator2);
        request.key = DataCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable SimpleEntryView<Data, Data> response, long maxIdle) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72961);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, maxIdle);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, response, SimpleEntryViewCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        response.maxIdle = FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
        response.response = CodecUtil.decodeNullable(iterator2, SimpleEntryViewCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public SimpleEntryView<Data, Data> response;
        public long maxIdle;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public long threadId;
    }
}

