/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigDecimalCodec {
    private BigDecimalCodec() {
    }

    public static void encode(ClientMessage clientMessage, BigDecimal value) {
        byte[] body = value.unscaledValue().toByteArray();
        byte[] buffer = new byte[4 + body.length + 4];
        FixedSizeTypesCodec.encodeInt(buffer, 0, body.length);
        System.arraycopy(body, 0, buffer, 4, body.length);
        FixedSizeTypesCodec.encodeInt(buffer, 4 + body.length, value.scale());
        clientMessage.add(new ClientMessage.Frame(buffer));
    }

    public static void encodeNullable(ClientMessage clientMessage, BigDecimal value) {
        if (value == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            BigDecimalCodec.encode(clientMessage, value);
        }
    }

    public static BigDecimal decode(ClientMessage.ForwardFrameIterator iterator2) {
        byte[] buffer = iterator2.next().content;
        int contentSize = FixedSizeTypesCodec.decodeInt(buffer, 0);
        byte[] body = new byte[contentSize];
        System.arraycopy(buffer, 4, body, 0, contentSize);
        int scale = FixedSizeTypesCodec.decodeInt(buffer, 4 + contentSize);
        return new BigDecimal(new BigInteger(body), scale);
    }

    public static BigDecimal decodeNullable(ClientMessage.ForwardFrameIterator iterator2) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator2) ? null : BigDecimalCodec.decode(iterator2);
    }
}

