/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.config.CacheSimpleConfig;

public final class DurationConfigCodec {
    private static final int DURATION_AMOUNT_FIELD_OFFSET = 0;
    private static final int TIME_UNIT_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 12;

    private DurationConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[12]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, durationConfig.getDurationAmount());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, durationConfig.getTimeUnit());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        long durationAmount = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        int timeUnit = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createDurationConfig(durationAmount, timeUnit);
    }
}

