/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.version.MemberVersion;

public final class MemberVersionCodec {
    private static final int MAJOR_FIELD_OFFSET = 0;
    private static final int MINOR_FIELD_OFFSET = 1;
    private static final int PATCH_FIELD_OFFSET = 2;
    private static final int INITIAL_FRAME_SIZE = 3;

    private MemberVersionCodec() {
    }

    public static void encode(ClientMessage clientMessage, MemberVersion memberVersion) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[3]);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 0, memberVersion.getMajor());
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 1, memberVersion.getMinor());
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 2, memberVersion.getPatch());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MemberVersion decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        byte major = FixedSizeTypesCodec.decodeByte(initialFrame.content, 0);
        byte minor = FixedSizeTypesCodec.decodeByte(initialFrame.content, 1);
        byte patch2 = FixedSizeTypesCodec.decodeByte(initialFrame.content, 2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new MemberVersion(major, minor, patch2);
    }
}

