/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.partition.MigrationState;

public final class MigrationStateCodec {
    private static final int START_TIME_FIELD_OFFSET = 0;
    private static final int PLANNED_MIGRATIONS_FIELD_OFFSET = 8;
    private static final int COMPLETED_MIGRATIONS_FIELD_OFFSET = 12;
    private static final int TOTAL_ELAPSED_TIME_FIELD_OFFSET = 16;
    private static final int INITIAL_FRAME_SIZE = 24;

    private MigrationStateCodec() {
    }

    public static void encode(ClientMessage clientMessage, MigrationState migrationState) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, migrationState.getStartTime());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, migrationState.getPlannedMigrations());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, migrationState.getCompletedMigrations());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, migrationState.getTotalElapsedTime());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MigrationStateImpl decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        long startTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        int plannedMigrations = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        int completedMigrations = FixedSizeTypesCodec.decodeInt(initialFrame.content, 12);
        long totalElapsedTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new MigrationStateImpl(startTime, plannedMigrations, completedMigrations, totalElapsedTime);
    }
}

