/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAllCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;

public class MapRemoveAllMessageTask
extends AbstractMapAllPartitionsMessageTask<MapRemoveAllCodec.RequestParameters> {
    private Predicate predicate;

    public MapRemoveAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        Operation operation;
        if (!(this.predicate instanceof PartitionPredicate)) {
            super.processMessage();
            return;
        }
        int partitionId = this.clientMessage.getPartitionId();
        OperationFactory operationFactory = this.createOperationFactory();
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        if (operationFactory instanceof PartitionAwareOperationFactory) {
            PartitionAwareOperationFactory partitionAwareOperationFactory = (PartitionAwareOperationFactory)operationFactory;
            partitionAwareOperationFactory = partitionAwareOperationFactory.createFactoryOnRunner(this.nodeEngine, new int[]{partitionId});
            operation = partitionAwareOperationFactory.createPartitionOperation(partitionId);
        } else {
            operation = operationFactory.createOperation();
        }
        int thisPartitionId = partitionId;
        operation.setCallerUuid(this.endpoint.getUuid());
        InvocationFuture future = operationService.invokeOnPartition(this.getServiceName(), operation, partitionId);
        future.whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                this.sendResponse(this.reduce(Collections.singletonMap(thisPartitionId, response)));
            } else {
                this.handleProcessingFailure((Throwable)throwable);
            }
        });
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getOperationProvider(((MapRemoveAllCodec.RequestParameters)this.parameters).name);
        Predicate effectivePredicate = this.predicate instanceof PartitionPredicate ? ((PartitionPredicate)this.predicate).getTarget() : this.predicate;
        return operationProvider.createPartitionWideEntryWithPredicateOperationFactory(((MapRemoveAllCodec.RequestParameters)this.parameters).name, EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR, effectivePredicate);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map2) {
        return null;
    }

    @Override
    protected MapRemoveAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        MapRemoveAllCodec.RequestParameters parameters = MapRemoveAllCodec.decodeRequest(clientMessage);
        this.predicate = (Predicate)this.serializationService.toObject(parameters.predicate);
        return parameters;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveAllCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveAllCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "removeAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveAllCodec.RequestParameters)this.parameters).predicate};
    }
}

