/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob;

import com.hazelcast.com.fasterxml.jackson.core.JsonLocation;
import com.hazelcast.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JSONObjectException
extends JsonProcessingException {
    private static final long serialVersionUID = 1L;
    static final int MAX_REFS_TO_LIST = 250;
    protected LinkedList<Reference> _path;

    public JSONObjectException(String string2) {
        super(string2);
    }

    public JSONObjectException(String string2, Throwable throwable) {
        super(string2, throwable);
    }

    public JSONObjectException(String string2, JsonLocation jsonLocation) {
        super(string2, jsonLocation);
    }

    public JSONObjectException(String string2, JsonLocation jsonLocation, Throwable throwable) {
        super(string2, jsonLocation, throwable);
    }

    public static JSONObjectException from(JsonParser jsonParser, String string2) {
        return new JSONObjectException(string2, jsonParser == null ? null : jsonParser.getTokenLocation());
    }

    public static JSONObjectException from(JsonParser jsonParser, String string2, Object ... objectArray) {
        if (objectArray.length > 0) {
            string2 = String.format(string2, objectArray);
        }
        return new JSONObjectException(string2, jsonParser == null ? null : jsonParser.getTokenLocation());
    }

    public static JSONObjectException from(JsonParser jsonParser, Throwable throwable, String string2, Object ... objectArray) {
        if (objectArray.length > 0) {
            string2 = String.format(string2, objectArray);
        }
        return new JSONObjectException(string2, jsonParser == null ? null : jsonParser.getTokenLocation(), throwable);
    }

    public static JSONObjectException fromUnexpectedIOE(IOException iOException) {
        return new JSONObjectException("Unexpected IOException (of type " + iOException.getClass().getName() + "): " + iOException.getMessage(), null, iOException);
    }

    public static JSONObjectException wrapWithPath(Throwable throwable, Object object, String string2) {
        return JSONObjectException.wrapWithPath(throwable, new Reference(object, string2));
    }

    public static JSONObjectException wrapWithPath(Throwable throwable, Object object, int n) {
        return JSONObjectException.wrapWithPath(throwable, new Reference(object, n));
    }

    public static JSONObjectException wrapWithPath(Throwable throwable, Reference reference) {
        JSONObjectException jSONObjectException;
        if (throwable instanceof JSONObjectException) {
            jSONObjectException = (JSONObjectException)throwable;
        } else {
            String string2 = throwable.getMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = "(was " + throwable.getClass().getName() + ")";
            }
            jSONObjectException = new JSONObjectException(string2, null, throwable);
        }
        jSONObjectException.prependPath(reference);
        return jSONObjectException;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    public void prependPath(Object object, String string2) {
        Reference reference = new Reference(object, string2);
        this.prependPath(reference);
    }

    public void prependPath(Object object, int n) {
        Reference reference = new Reference(object, n);
        this.prependPath(reference);
    }

    public void prependPath(Reference reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 250) {
            this._path.addFirst(reference);
        }
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String string2 = super.getMessage();
        if (this._path == null) {
            return string2;
        }
        StringBuilder stringBuilder = string2 == null ? new StringBuilder() : new StringBuilder(string2);
        stringBuilder.append(" (through reference chain: ");
        stringBuilder = this.getPathReference(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        if (this._path == null) {
            return;
        }
        Iterator iterator2 = this._path.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append(((Reference)iterator2.next()).toString());
            if (!iterator2.hasNext()) continue;
            stringBuilder.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Object _from;
        protected String _fieldName;
        protected int _index = -1;

        protected Reference() {
        }

        public Reference(Object object) {
            this._from = object;
        }

        public Reference(Object object, String string2) {
            this._from = object;
            if (string2 == null) {
                throw new NullPointerException("Can not pass null fieldName");
            }
            this._fieldName = string2;
        }

        public Reference(Object object, int n) {
            this._from = object;
            this._index = n;
        }

        public void setFrom(Object object) {
            this._from = object;
        }

        public void setFieldName(String string2) {
            this._fieldName = string2;
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public Object getFrom() {
            return this._from;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getIndex() {
            return this._index;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Class<?> clazz = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
            Package package_ = clazz.getPackage();
            if (package_ != null) {
                stringBuilder.append(package_.getName());
                stringBuilder.append('.');
            }
            stringBuilder.append(clazz.getSimpleName());
            stringBuilder.append('[');
            if (this._fieldName != null) {
                stringBuilder.append('\"');
                stringBuilder.append(this._fieldName);
                stringBuilder.append('\"');
            } else if (this._index >= 0) {
                stringBuilder.append(this._index);
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

