/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.impl.DefaultMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

class PoolingMetricDescriptorSupplier
implements Supplier<MetricDescriptorImpl> {
    static final int INITIAL_CAPACITY = 32;
    private static final double GROW_FACTOR = 1.2;
    private final List<MetricDescriptorImpl> allCreated = new ArrayList<MetricDescriptorImpl>(32);
    private MetricDescriptorImpl[] pool = new MetricDescriptorImpl[32];
    private int poolPtr;
    private boolean closed;

    PoolingMetricDescriptorSupplier() {
        for (int i = 0; i < this.pool.length; ++i) {
            MetricDescriptorImpl descriptor;
            this.pool[i] = descriptor = new MetricDescriptorImpl(this);
            this.allCreated.add(descriptor);
        }
        this.poolPtr = this.pool.length - 1;
    }

    @Override
    public MetricDescriptorImpl get() {
        if (this.closed) {
            throw new IllegalStateException("This PoolingMetricDescriptorSupplier is already closed and cannot supply");
        }
        if (this.poolPtr >= 0) {
            MetricDescriptorImpl descriptor = this.pool[this.poolPtr];
            this.pool[this.poolPtr--] = null;
            descriptor.reset();
            return descriptor;
        }
        MetricDescriptorImpl descriptor = new MetricDescriptorImpl(this);
        this.allCreated.add(descriptor);
        return descriptor;
    }

    void recycle(MetricDescriptorImpl descriptor) {
        this.ensureCapacity(this.poolPtr + 1);
        this.pool[++this.poolPtr] = descriptor;
    }

    void close() {
        this.closed = true;
        for (MetricDescriptorImpl descriptor : this.allCreated) {
            descriptor.setSupplier(DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER);
        }
        this.allCreated.clear();
        Arrays.fill(this.pool, null);
    }

    private void ensureCapacity(int poolPtr) {
        if (poolPtr < this.pool.length - 1) {
            return;
        }
        int newCapacity = (int)Math.ceil((double)poolPtr * 1.2);
        MetricDescriptorImpl[] newPool = new MetricDescriptorImpl[newCapacity];
        System.arraycopy(this.pool, 0, newPool, 0, this.pool.length);
        this.pool = newPool;
    }
}

