/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.accumulator;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.map.impl.querycache.accumulator.CyclicBuffer;
import com.hazelcast.map.impl.querycache.event.sequence.Sequenced;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultCyclicBuffer<E extends Sequenced>
implements CyclicBuffer<E> {
    private static final long UNSET = -1L;
    private int capacity;
    private E[] buffer;
    private AtomicLong headSequence;
    private AtomicLong tailSequence;

    public DefaultCyclicBuffer(int capacity) throws IllegalArgumentException {
        Preconditions.checkPositive("capacity", capacity);
        this.init(capacity);
    }

    private void init(int maxSize) {
        this.capacity = QuickMath.nextPowerOfTwo(maxSize);
        this.buffer = new Sequenced[this.capacity];
        this.tailSequence = new AtomicLong(-1L);
        this.headSequence = new AtomicLong(-1L);
    }

    @Override
    public void add(E event) {
        int headIndex;
        Preconditions.checkNotNull(event, "event cannot be null");
        Preconditions.checkPositive("sequence", event.getSequence());
        long sequence2 = event.getSequence();
        int tailIndex = this.findIndex(sequence2);
        this.buffer[tailIndex] = event;
        this.tailSequence.set(sequence2);
        long head2 = this.headSequence.get();
        if (head2 == -1L) {
            this.headSequence.set(sequence2);
        } else if (head2 != sequence2 && (headIndex = this.findIndex(head2)) == tailIndex) {
            E e;
            if (++headIndex == this.capacity) {
                headIndex = 0;
            }
            if ((e = this.buffer[headIndex]) != null) {
                this.headSequence.set(e.getSequence());
            } else {
                this.headSequence.incrementAndGet();
            }
        }
    }

    @Override
    public E get(long sequence2) {
        Preconditions.checkPositive("sequence", sequence2);
        int index = this.findIndex(sequence2);
        E e = this.buffer[index];
        if (e != null && e.getSequence() != sequence2) {
            return null;
        }
        return e;
    }

    @Override
    public boolean setHead(long sequence2) {
        Preconditions.checkPositive("sequence", sequence2);
        E e = this.get(sequence2);
        if (e == null) {
            return false;
        }
        this.headSequence.set(sequence2);
        return true;
    }

    @Override
    public E getAndAdvance() {
        long head2 = this.headSequence.get();
        long tail = this.tailSequence.get();
        if (tail == -1L || head2 > tail) {
            return null;
        }
        int headIndex = this.findIndex(head2);
        E e = this.buffer[headIndex];
        if (e == null) {
            return null;
        }
        this.headSequence.incrementAndGet();
        return e;
    }

    @Override
    public void reset() {
        this.init(this.capacity);
    }

    @Override
    public int size() {
        long head2 = this.headSequence.get();
        long tail = this.tailSequence.get();
        if (tail == -1L) {
            return 0;
        }
        return (int)(tail - head2 + 1L);
    }

    @Override
    public long getHeadSequence() {
        return this.headSequence.get();
    }

    private int findIndex(long sequence2) {
        return (int)(sequence2 % (long)this.capacity);
    }
}

