/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.DataCollection;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.operations.AbstractMultiMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Collection;

public class PutAllBackupOperation
extends AbstractMultiMapOperation
implements BackupOperation {
    private transient int currentIndex;
    private MapEntries mapEntries;

    public PutAllBackupOperation() {
    }

    public PutAllBackupOperation(String name, MapEntries mapEntries) {
        super(name);
        this.mapEntries = mapEntries;
    }

    @Override
    public void run() throws Exception {
        int size2;
        int n = size2 = this.mapEntries != null ? this.mapEntries.size() : 0;
        while (this.currentIndex < size2) {
            Data dataKey = this.mapEntries.getKey(this.currentIndex);
            Data value = this.mapEntries.getValue(this.currentIndex);
            this.put(dataKey, value);
            ++this.currentIndex;
        }
    }

    protected void put(Data dataKey, Data dataValue) {
        MultiMapContainer container = this.getOrCreateContainer();
        Collection<Data> c = ((DataCollection)this.toObject(dataValue)).getCollection();
        Collection<MultiMapRecord> coll = container.getOrCreateMultiMapValue(dataKey).getCollection(false);
        for (Data o : c) {
            MultiMapRecord record = new MultiMapRecord(container.nextId(), this.isBinary() ? o : this.toObject(o));
            if (!coll.add(record)) continue;
            this.response = true;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mapEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapEntries = (MapEntries)in.readObject();
    }

    @Override
    public int getClassId() {
        return 54;
    }
}

