/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.splitbrainprotection.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.internal.cluster.fd.PhiAccrualClusterFailureDetector;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.splitbrainprotection.HeartbeatAware;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.AbstractPingAwareSplitBrainProtectionFunction;
import java.util.Collection;

public class ProbabilisticSplitBrainProtectionFunction
extends AbstractPingAwareSplitBrainProtectionFunction
implements HeartbeatAware,
SplitBrainProtectionFunction,
MembershipListener {
    private final double suspicionThreshold;
    private final int minimumClusterSize;
    private final int maxSampleSize;
    private final long minStdDeviationMillis;
    private final long acceptableHeartbeatPauseMillis;
    private final long heartbeatIntervalMillis;
    private final PhiAccrualClusterFailureDetector failureDetector;

    public ProbabilisticSplitBrainProtectionFunction(int minimumClusterSize, long heartbeatIntervalMillis, long acceptableHeartbeatPauseMillis, int maxSampleSize, long minStdDeviationMillis, double suspicionThreshold) {
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPauseMillis;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviationMillis = minStdDeviationMillis;
        this.suspicionThreshold = suspicionThreshold;
        this.minimumClusterSize = minimumClusterSize;
        this.failureDetector = new PhiAccrualClusterFailureDetector(acceptableHeartbeatPauseMillis, heartbeatIntervalMillis, suspicionThreshold, maxSampleSize, minStdDeviationMillis);
    }

    @Override
    public boolean apply(Collection<Member> members) {
        if (members.size() < this.minimumClusterSize) {
            return false;
        }
        int count2 = 0;
        long timestamp = Clock.currentTimeMillis();
        for (Member member : members) {
            if (!this.isAlivePerIcmp(member) || !member.localMember() && !this.failureDetector.isAlive(member, timestamp)) continue;
            ++count2;
        }
        return count2 >= this.minimumClusterSize;
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        super.memberRemoved(membershipEvent);
        this.failureDetector.remove(membershipEvent.getMember());
    }

    @Override
    public void onHeartbeat(Member member, long timestamp) {
        this.failureDetector.heartbeat(member, timestamp);
    }

    public double getSuspicionThreshold() {
        return this.suspicionThreshold;
    }

    public int getMaxSampleSize() {
        return this.maxSampleSize;
    }

    public long getMinStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    public long getAcceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public long getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProbabilisticSplitBrainProtectionFunction that = (ProbabilisticSplitBrainProtectionFunction)o;
        if (Double.compare(that.suspicionThreshold, this.suspicionThreshold) != 0) {
            return false;
        }
        if (this.minimumClusterSize != that.minimumClusterSize) {
            return false;
        }
        if (this.maxSampleSize != that.maxSampleSize) {
            return false;
        }
        if (this.minStdDeviationMillis != that.minStdDeviationMillis) {
            return false;
        }
        if (this.acceptableHeartbeatPauseMillis != that.acceptableHeartbeatPauseMillis) {
            return false;
        }
        return this.heartbeatIntervalMillis == that.heartbeatIntervalMillis;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.suspicionThreshold);
        int result2 = (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + this.minimumClusterSize;
        result2 = 31 * result2 + this.maxSampleSize;
        result2 = 31 * result2 + (int)(this.minStdDeviationMillis ^ this.minStdDeviationMillis >>> 32);
        result2 = 31 * result2 + (int)(this.acceptableHeartbeatPauseMillis ^ this.acceptableHeartbeatPauseMillis >>> 32);
        result2 = 31 * result2 + (int)(this.heartbeatIntervalMillis ^ this.heartbeatIntervalMillis >>> 32);
        return result2;
    }
}

