/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.io.IOException;

public final class ColumnExpression<T>
implements Expression<T>,
IdentifiedDataSerializable {
    private int index;
    private QueryDataType type;

    public ColumnExpression() {
    }

    private ColumnExpression(int index, QueryDataType type) {
        this.index = index;
        this.type = type;
    }

    public static ColumnExpression<?> create(int index, QueryDataType type) {
        Class<?> canonicalClass = type.getConverter().getNormalizedValueClass();
        QueryDataType canonicalType = QueryDataTypeUtils.resolveTypeForClass(canonicalClass);
        return new ColumnExpression(index, canonicalType);
    }

    @Override
    public Object evalTop(Row row, ExpressionEvalContext context) {
        Object res = row.get(this.index);
        if (res instanceof LazyTarget) {
            assert (this.type.equals(QueryDataType.OBJECT));
            LazyTarget lazyTarget = (LazyTarget)res;
            res = lazyTarget.getDeserialized() != null ? lazyTarget.getDeserialized() : lazyTarget.getSerialized();
        }
        return res;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object res = row.get(this.index);
        if (res instanceof LazyTarget) {
            assert (this.type.equals(QueryDataType.OBJECT));
            res = ((LazyTarget)res).deserialize(context.getSerializationService());
        }
        return res;
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.index = in.readInt();
        this.type = (QueryDataType)in.readObject();
    }

    public int hashCode() {
        int result2 = this.index;
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnExpression that = (ColumnExpression)o;
        return this.index == that.index && this.type.equals(that.type);
    }
}

