/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.Searchable;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;

public class SearchableExpression<C extends Comparable<C>>
implements Expression<Searchable<C>>,
IdentifiedDataSerializable {
    private QueryDataType type;
    private Searchable<C> searchable;

    public SearchableExpression() {
    }

    private SearchableExpression(QueryDataType type, Searchable<C> searchable) {
        this.type = type;
        this.searchable = searchable;
    }

    public static SearchableExpression<?> create(QueryDataType type, Searchable<?> searchable) {
        return new SearchableExpression(type, searchable);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 59;
    }

    @Override
    public Searchable<C> eval(Row row, ExpressionEvalContext context) {
        return this.searchable;
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.type);
        out.writeObject(this.searchable);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.type = (QueryDataType)in.readObject();
        this.searchable = (Searchable)in.readObject();
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + (this.searchable != null ? this.searchable.hashCode() : 0);
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchableExpression that = (SearchableExpression)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.searchable, that.searchable);
    }

    public String toString() {
        return "SearchableExpression{type=" + this.type + ", searchable=" + this.searchable + '}';
    }
}

