/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.command;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.StringFormatUtils;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.enums.MasterType;
import org.apache.seatunnel.core.starter.exception.CommandExecuteException;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.apache.seatunnel.engine.client.SeaTunnelClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobExecutionEnvironment;
import org.apache.seatunnel.engine.client.job.JobMetricsRunner;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelNodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExecuteCommand
implements Command<ClientCommandArgs> {
    private static final Logger log = LoggerFactory.getLogger(ClientExecuteCommand.class);
    private final ClientCommandArgs clientCommandArgs;
    private JobStatus jobStatus;
    private SeaTunnelClient engineClient;
    private HazelcastInstance instance;
    private ScheduledExecutorService executorService;

    public ClientExecuteCommand(ClientCommandArgs clientCommandArgs) {
        this.clientCommandArgs = clientCommandArgs;
    }

    @Override
    public void execute() throws CommandExecuteException {
        LocalDateTime endTime;
        LocalDateTime startTime;
        JobMetricsRunner.JobMetricsSummary jobMetricsSummary;
        block17: {
            ClientJobProxy clientJobProxy;
            SeaTunnelConfig seaTunnelConfig;
            block18: {
                block19: {
                    jobMetricsSummary = null;
                    startTime = LocalDateTime.now();
                    endTime = LocalDateTime.now();
                    seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
                    String clusterName = this.clientCommandArgs.getClusterName();
                    if (this.clientCommandArgs.getMasterType().equals((Object)MasterType.LOCAL)) {
                        clusterName = this.creatRandomClusterName(StringUtils.isNotEmpty(clusterName) ? clusterName : "seatunnel");
                        this.instance = this.createServerInLocal(clusterName, seaTunnelConfig);
                    }
                    if (StringUtils.isNotEmpty(clusterName)) {
                        seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
                    }
                    ClientConfig clientConfig = ConfigProvider.locateAndGetClientConfig();
                    if (StringUtils.isNotEmpty(clusterName)) {
                        clientConfig.setClusterName(clusterName);
                    }
                    this.engineClient = new SeaTunnelClient(clientConfig);
                    if (this.clientCommandArgs.isListJob()) {
                        String jobStatus = this.engineClient.getJobClient().listJobStatus(true);
                        System.out.println(jobStatus);
                        break block17;
                    }
                    if (this.clientCommandArgs.isGetRunningJobMetrics()) {
                        String runningJobMetrics = this.engineClient.getJobClient().getRunningJobMetrics();
                        System.out.println(runningJobMetrics);
                        break block17;
                    }
                    if (null != this.clientCommandArgs.getJobId()) {
                        String jobState = this.engineClient.getJobClient().getJobDetailStatus(Long.parseLong(this.clientCommandArgs.getJobId()));
                        System.out.println(jobState);
                        break block17;
                    }
                    if (null != this.clientCommandArgs.getCancelJobId()) {
                        this.engineClient.getJobClient().cancelJob(Long.parseLong(this.clientCommandArgs.getCancelJobId()));
                        break block17;
                    }
                    if (null != this.clientCommandArgs.getMetricsJobId()) {
                        String jobMetrics = this.engineClient.getJobClient().getJobMetrics(Long.parseLong(this.clientCommandArgs.getMetricsJobId()));
                        System.out.println(jobMetrics);
                        break block17;
                    }
                    if (null != this.clientCommandArgs.getSavePointJobId()) {
                        this.engineClient.getJobClient().savePointJob(Long.parseLong(this.clientCommandArgs.getSavePointJobId()));
                        break block17;
                    }
                    Path configFile = FileUtils.getConfigPath(this.clientCommandArgs);
                    FileUtils.checkConfigExist(configFile);
                    JobConfig jobConfig = new JobConfig();
                    jobConfig.setName(this.clientCommandArgs.getJobName());
                    JobExecutionEnvironment jobExecutionEnv = null != this.clientCommandArgs.getRestoreJobId() ? this.engineClient.restoreExecutionContext(configFile.toString(), jobConfig, Long.parseLong(this.clientCommandArgs.getRestoreJobId())) : this.engineClient.createExecutionContext(configFile.toString(), jobConfig);
                    startTime = LocalDateTime.now();
                    clientJobProxy = jobExecutionEnv.execute();
                    if (!this.clientCommandArgs.isAsync()) break block18;
                    if (this.clientCommandArgs.getMasterType().equals((Object)MasterType.LOCAL)) {
                        log.warn("The job is running in local mode, can not use async mode.");
                        break block18;
                    }
                    if (jobMetricsSummary == null) break block19;
                    log.info(StringFormatUtils.formatTable("Job Statistic Information", "Start Time", DateTimeUtils.toString(startTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "End Time", DateTimeUtils.toString(endTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "Total Time(s)", Duration.between(startTime, endTime).getSeconds(), "Total Read Count", jobMetricsSummary.getSourceReadCount(), "Total Write Count", jobMetricsSummary.getSinkWriteCount(), "Total Failed Count", jobMetricsSummary.getSourceReadCount() - jobMetricsSummary.getSinkWriteCount()));
                }
                this.closeClient();
                return;
            }
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        log.info("run shutdown hook because get close signal");
                        this.shutdownHook(clientJobProxy);
                    });
                    try {
                        future.get(15L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        log.error("Cancel job failed.", e);
                    }
                }));
                long jobId = clientJobProxy.getJobId();
                JobMetricsRunner jobMetricsRunner = new JobMetricsRunner(this.engineClient, jobId);
                this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("job-metrics-runner-%d").setDaemon(true).build());
                this.executorService.scheduleAtFixedRate(jobMetricsRunner, 0L, seaTunnelConfig.getEngineConfig().getPrintJobMetricsInfoInterval(), TimeUnit.SECONDS);
                this.jobStatus = clientJobProxy.waitForJobComplete();
                endTime = LocalDateTime.now();
                jobMetricsSummary = this.engineClient.getJobMetricsSummary(jobId);
            }
            catch (Exception e) {
                try {
                    throw new CommandExecuteException("SeaTunnel job executed failed", e);
                }
                catch (Throwable throwable) {
                    if (jobMetricsSummary != null) {
                        log.info(StringFormatUtils.formatTable("Job Statistic Information", "Start Time", DateTimeUtils.toString(startTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "End Time", DateTimeUtils.toString(endTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "Total Time(s)", Duration.between(startTime, endTime).getSeconds(), "Total Read Count", jobMetricsSummary.getSourceReadCount(), "Total Write Count", jobMetricsSummary.getSinkWriteCount(), "Total Failed Count", jobMetricsSummary.getSourceReadCount() - jobMetricsSummary.getSinkWriteCount()));
                    }
                    this.closeClient();
                    throw throwable;
                }
            }
        }
        if (jobMetricsSummary != null) {
            log.info(StringFormatUtils.formatTable("Job Statistic Information", "Start Time", DateTimeUtils.toString(startTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "End Time", DateTimeUtils.toString(endTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "Total Time(s)", Duration.between(startTime, endTime).getSeconds(), "Total Read Count", jobMetricsSummary.getSourceReadCount(), "Total Write Count", jobMetricsSummary.getSinkWriteCount(), "Total Failed Count", jobMetricsSummary.getSourceReadCount() - jobMetricsSummary.getSinkWriteCount()));
        }
        this.closeClient();
    }

    private void closeClient() {
        if (this.engineClient != null) {
            this.engineClient.close();
            log.info("Closed SeaTunnel client......");
        }
        if (this.instance != null) {
            this.instance.shutdown();
            log.info("Closed HazelcastInstance ......");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            log.info("Closed metrics executor service ......");
        }
    }

    private HazelcastInstance createServerInLocal(String clusterName, SeaTunnelConfig seaTunnelConfig) {
        seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
        seaTunnelConfig.getHazelcastConfig().getNetworkConfig().setPortAutoIncrement(true);
        return HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), Thread.currentThread().getName(), new SeaTunnelNodeContext(seaTunnelConfig));
    }

    private String creatRandomClusterName(String namePrefix) {
        Random random = new Random();
        return namePrefix + "-" + random.nextInt(1000000);
    }

    private void shutdownHook(ClientJobProxy clientJobProxy) {
        if (this.clientCommandArgs.isCloseJob() && clientJobProxy.getJobResultCache() == null && (this.jobStatus == null || !this.jobStatus.isEndState())) {
            log.warn("Task will be closed due to client shutdown.");
            clientJobProxy.cancelJob();
        }
    }
}

