/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.google.common.collect.Lists;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.StringFormatUtils;
import org.apache.seatunnel.engine.common.Constant;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;
import org.apache.seatunnel.engine.common.exception.JobNotFoundException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskCallTimer;
import org.apache.seatunnel.engine.server.execution.TaskDeployState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionContext;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroup;
import org.apache.seatunnel.engine.server.execution.TaskGroupContext;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.execution.TaskTracker;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.TaskGroupImmutableInformation;
import org.apache.seatunnel.engine.server.task.operation.NotifyTaskStatusOperation;

public class TaskExecutionService
implements DynamicMetricsProvider {
    private final String hzInstanceName;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private volatile boolean isRunning = true;
    private final LinkedBlockingDeque<TaskTracker> threadShareTaskQueue = new LinkedBlockingDeque();
    private final ExecutorService executorService = Executors.newCachedThreadPool(new BlockingTaskThreadFactory());
    private final RunBusWorkSupplier runBusWorkSupplier = new RunBusWorkSupplier(this.executorService, this.threadShareTaskQueue);
    private final ConcurrentMap<TaskGroupLocation, TaskGroupContext> executionContexts = new ConcurrentHashMap<TaskGroupLocation, TaskGroupContext>();
    private final ConcurrentMap<TaskGroupLocation, TaskGroupContext> finishedExecutionContexts = new ConcurrentHashMap<TaskGroupLocation, TaskGroupContext>();
    private final ConcurrentMap<TaskGroupLocation, Map<String, CompletableFuture<?>>> taskAsyncFunctionFuture = new ConcurrentHashMap();
    private final ConcurrentMap<TaskGroupLocation, CompletableFuture<Void>> cancellationFutures = new ConcurrentHashMap<TaskGroupLocation, CompletableFuture<Void>>();
    private final SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
    private final ScheduledExecutorService scheduledExecutorService;

    public TaskExecutionService(NodeEngineImpl nodeEngine, HazelcastProperties properties) {
        this.hzInstanceName = nodeEngine.getHazelcastInstance().getName();
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLoggingService().getLogger(TaskExecutionService.class);
        MetricsRegistry registry = nodeEngine.getMetricsRegistry();
        MetricDescriptor descriptor = registry.newMetricDescriptor().withTag("service", this.getClass().getSimpleName());
        registry.registerStaticMetrics(descriptor, this);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateMetricsContextInImap, 0L, this.seaTunnelConfig.getEngineConfig().getJobMetricsBackupInterval(), TimeUnit.SECONDS);
    }

    public void start() {
        this.runBusWorkSupplier.runNewBusWork(false);
    }

    public void shutdown() {
        this.isRunning = false;
        this.executorService.shutdownNow();
        this.scheduledExecutorService.shutdown();
    }

    public TaskGroupContext getExecutionContext(TaskGroupLocation taskGroupLocation) {
        TaskGroupContext taskGroupContext = (TaskGroupContext)this.executionContexts.get(taskGroupLocation);
        if (taskGroupContext == null) {
            taskGroupContext = (TaskGroupContext)this.finishedExecutionContexts.get(taskGroupLocation);
        }
        if (taskGroupContext == null) {
            throw new TaskGroupContextNotFoundException(String.format("task group %s not found.", taskGroupLocation));
        }
        return taskGroupContext;
    }

    public TaskGroupContext getActiveExecutionContext(TaskGroupLocation taskGroupLocation) {
        TaskGroupContext taskGroupContext = (TaskGroupContext)this.executionContexts.get(taskGroupLocation);
        if (taskGroupContext == null) {
            throw new TaskGroupContextNotFoundException(String.format("task group %s not found.", taskGroupLocation));
        }
        return taskGroupContext;
    }

    private void submitThreadShareTask(TaskGroupExecutionTracker taskGroupExecutionTracker, List<Task> tasks) {
        Stream<TaskTracker> taskTrackerStream = tasks.stream().map(t -> {
            if (!taskGroupExecutionTracker.executionCompletedExceptionally()) {
                try {
                    TaskTracker taskTracker = new TaskTracker((Task)t, taskGroupExecutionTracker);
                    taskTracker.task.init();
                    return taskTracker;
                }
                catch (Exception e) {
                    taskGroupExecutionTracker.exception(e);
                    taskGroupExecutionTracker.taskDone((Task)t);
                }
            }
            return null;
        });
        if (!taskGroupExecutionTracker.executionCompletedExceptionally()) {
            taskTrackerStream.forEach(this.threadShareTaskQueue::add);
        }
    }

    private void submitBlockingTask(TaskGroupExecutionTracker taskGroupExecutionTracker, List<Task> tasks) {
        CountDownLatch startedLatch = new CountDownLatch(tasks.size());
        taskGroupExecutionTracker.blockingFutures = tasks.stream().map(t -> new BlockingWorker(new TaskTracker((Task)t, taskGroupExecutionTracker), startedLatch)).map(this.executorService::submit).collect(Collectors.toList());
        Util.uncheckRun(startedLatch::await);
    }

    public TaskDeployState deployTask(@NonNull Data taskImmutableInformation) {
        if (taskImmutableInformation == null) {
            throw new NullPointerException("taskImmutableInformation is marked non-null but is null");
        }
        TaskGroupImmutableInformation taskImmutableInfo = (TaskGroupImmutableInformation)this.nodeEngine.getSerializationService().toObject(taskImmutableInformation);
        return this.deployTask(taskImmutableInfo);
    }

    public <T extends Task> T getTask(@NonNull TaskLocation taskLocation) {
        if (taskLocation == null) {
            throw new NullPointerException("taskLocation is marked non-null but is null");
        }
        TaskGroupContext executionContext = this.getActiveExecutionContext(taskLocation.getTaskGroupLocation());
        return executionContext.getTaskGroup().getTask(taskLocation.getTaskID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDeployState deployTask(@NonNull TaskGroupImmutableInformation taskImmutableInfo) {
        if (taskImmutableInfo == null) {
            throw new NullPointerException("taskImmutableInfo is marked non-null but is null");
        }
        this.logger.info(String.format("received deploying task executionId [%s]", taskImmutableInfo.getExecutionId()));
        TaskGroup taskGroup = null;
        try {
            Set<URL> jars = taskImmutableInfo.getJars();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!CollectionUtils.isEmpty(jars)) {
                classLoader = new SeaTunnelChildFirstClassLoader(Lists.newArrayList(jars));
                taskGroup = (TaskGroup)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), classLoader, taskImmutableInfo.getGroup());
            } else {
                taskGroup = (TaskGroup)this.nodeEngine.getSerializationService().toObject(taskImmutableInfo.getGroup());
            }
            this.logger.info(String.format("deploying task %s, executionId [%s]", taskGroup.getTaskGroupLocation(), taskImmutableInfo.getExecutionId()));
            TaskExecutionService taskExecutionService = this;
            synchronized (taskExecutionService) {
                if (this.executionContexts.containsKey(taskGroup.getTaskGroupLocation())) {
                    throw new RuntimeException(String.format("TaskGroupLocation: %s already exists", taskGroup.getTaskGroupLocation()));
                }
                this.deployLocalTask(taskGroup, classLoader);
                return TaskDeployState.success();
            }
        }
        catch (Throwable t) {
            this.logger.severe(String.format("TaskGroupID : %s  deploy error with Exception: %s", taskGroup != null && taskGroup.getTaskGroupLocation() != null ? taskGroup.getTaskGroupLocation().toString() : "taskGroupLocation is null", ExceptionUtils.getMessage(t)));
            return TaskDeployState.failed(t);
        }
    }

    @Deprecated
    public PassiveCompletableFuture<TaskExecutionState> deployLocalTask(@NonNull TaskGroup taskGroup) {
        if (taskGroup == null) {
            throw new NullPointerException("taskGroup is marked non-null but is null");
        }
        return this.deployLocalTask(taskGroup, Thread.currentThread().getContextClassLoader());
    }

    public PassiveCompletableFuture<TaskExecutionState> deployLocalTask(@NonNull TaskGroup taskGroup, @NonNull ClassLoader classLoader) {
        if (taskGroup == null) {
            throw new NullPointerException("taskGroup is marked non-null but is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        CompletableFuture<TaskExecutionState> resultFuture = new CompletableFuture<TaskExecutionState>();
        try {
            taskGroup.init();
            this.logger.info(String.format("deploying TaskGroup %s init success", taskGroup.getTaskGroupLocation()));
            Collection<Task> tasks = taskGroup.getTasks();
            CompletableFuture<Void> cancellationFuture = new CompletableFuture<Void>();
            TaskGroupExecutionTracker executionTracker = new TaskGroupExecutionTracker(cancellationFuture, taskGroup, resultFuture);
            ConcurrentHashMap<Long, TaskExecutionContext> taskExecutionContextMap = new ConcurrentHashMap<Long, TaskExecutionContext>();
            Map<Boolean, List<Task>> byCooperation = tasks.stream().peek(task -> {
                TaskExecutionContext taskExecutionContext = new TaskExecutionContext((Task)task, this.nodeEngine, this);
                task.setTaskExecutionContext(taskExecutionContext);
                taskExecutionContextMap.put(task.getTaskID(), taskExecutionContext);
            }).collect(Collectors.partitioningBy(t -> {
                ThreadShareMode mode = this.seaTunnelConfig.getEngineConfig().getTaskExecutionThreadShareMode();
                if (mode.equals((Object)ThreadShareMode.ALL)) {
                    return true;
                }
                if (mode.equals((Object)ThreadShareMode.OFF)) {
                    return false;
                }
                if (mode.equals((Object)ThreadShareMode.PART)) {
                    return t.isThreadsShare();
                }
                return true;
            }));
            this.executionContexts.put(taskGroup.getTaskGroupLocation(), new TaskGroupContext(taskGroup, classLoader));
            this.cancellationFutures.put(taskGroup.getTaskGroupLocation(), cancellationFuture);
            this.submitThreadShareTask(executionTracker, byCooperation.get(true));
            this.submitBlockingTask(executionTracker, byCooperation.get(false));
            taskGroup.setTasksContext(taskExecutionContextMap);
            this.logger.info(String.format("deploying TaskGroup %s success", taskGroup.getTaskGroupLocation()));
        }
        catch (Throwable t2) {
            this.logger.severe(ExceptionUtils.getMessage(t2));
            resultFuture.completeExceptionally(t2);
        }
        resultFuture.whenCompleteAsync((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (r, s2) -> {
            if (s2 != null) {
                this.logger.severe(String.format("Task %s complete with error %s", taskGroup.getTaskGroupLocation(), ExceptionUtils.getMessage(s2)));
            }
            if (r == null) {
                r = new TaskExecutionState(taskGroup.getTaskGroupLocation(), ExecutionState.FAILED, (Throwable)s2);
            }
            this.logger.info(String.format("Task %s complete with state %s", r.getTaskGroupLocation(), r.getExecutionState()));
            this.notifyTaskStatusToMaster(taskGroup.getTaskGroupLocation(), (TaskExecutionState)r);
        }), (Executor)this.executorService);
        return new PassiveCompletableFuture<TaskExecutionState>(resultFuture);
    }

    private void notifyTaskStatusToMaster(TaskGroupLocation taskGroupLocation, TaskExecutionState taskExecutionState) {
        long sleepTime = 1000L;
        boolean notifyStateSuccess = false;
        while (this.isRunning && !notifyStateSuccess) {
            InvocationFuture invoke = this.nodeEngine.getOperationService().createInvocationBuilder("st:impl:seaTunnelServer", (Operation)new NotifyTaskStatusOperation(taskGroupLocation, taskExecutionState), this.nodeEngine.getMasterAddress()).invoke();
            try {
                invoke.get();
                notifyStateSuccess = true;
            }
            catch (InterruptedException e) {
                this.logger.severe("send notify task status failed", e);
            }
            catch (JobNotFoundException e) {
                this.logger.warning("send notify task status failed because can't find job", e);
                notifyStateSuccess = true;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof JobNotFoundException) {
                    this.logger.warning("send notify task status failed because can't find job", e);
                    notifyStateSuccess = true;
                    continue;
                }
                this.logger.warning(ExceptionUtils.getMessage(e));
                this.logger.warning(String.format("notify the job of the task(%s) status failed, retry in %s millis", taskGroupLocation, sleepTime));
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ex) {
                    this.logger.severe(e);
                }
            }
        }
    }

    public void cancelTaskGroup(TaskGroupLocation taskGroupLocation) {
        this.logger.info(String.format("Task (%s) need cancel.", taskGroupLocation));
        if (this.cancellationFutures.containsKey(taskGroupLocation)) {
            try {
                ((CompletableFuture)this.cancellationFutures.get(taskGroupLocation)).cancel(false);
            }
            catch (CancellationException cancellationException) {}
        } else {
            this.logger.warning(String.format("need cancel taskId : %s is not exist", taskGroupLocation));
        }
    }

    public void asyncExecuteFunction(TaskGroupLocation taskGroupLocation, Runnable task) {
        String id = UUID.randomUUID().toString();
        this.logger.fine("accept async execute function from " + taskGroupLocation + " with id " + id);
        if (!this.taskAsyncFunctionFuture.containsKey(taskGroupLocation)) {
            this.taskAsyncFunctionFuture.put(taskGroupLocation, new ConcurrentHashMap());
        }
        CompletableFuture<Void> future = CompletableFuture.runAsync(task, this.executorService);
        ((Map)this.taskAsyncFunctionFuture.get(taskGroupLocation)).put(id, future);
        future.whenComplete((r, e) -> {
            ((Map)this.taskAsyncFunctionFuture.get(taskGroupLocation)).remove(id);
            this.logger.fine("remove async execute function from " + taskGroupLocation + " with id " + id);
        });
    }

    public void notifyCleanTaskGroupContext(TaskGroupLocation taskGroupLocation) {
        this.finishedExecutionContexts.remove(taskGroupLocation);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        try {
            MetricDescriptor copy1 = descriptor.copy().withTag("service", this.getClass().getSimpleName());
            HashMap<TaskGroupLocation, TaskGroupContext> contextMap = new HashMap<TaskGroupLocation, TaskGroupContext>();
            contextMap.putAll(this.finishedExecutionContexts);
            contextMap.putAll(this.executionContexts);
            contextMap.forEach((taskGroupLocation, taskGroupContext) -> {
                MetricDescriptor copy2 = copy1.copy().withTag("taskGroupLocation", taskGroupLocation.toString()).withTag("jobId", String.valueOf(taskGroupLocation.getJobId())).withTag("pipelineId", String.valueOf(taskGroupLocation.getPipelineId())).withTag("taskGroupId", String.valueOf(taskGroupLocation.getTaskGroupId()));
                taskGroupContext.getTaskGroup().getTasks().forEach(task -> {
                    Long taskID = task.getTaskID();
                    MetricDescriptor copy3 = copy2.copy().withTag("taskID", String.valueOf(taskID));
                    task.provideDynamicMetrics(copy3, context);
                });
            });
        }
        catch (Throwable t) {
            this.logger.warning("Dynamic metric collection failed", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricsContextInImap() {
        if (!this.nodeEngine.getNode().getState().equals((Object)NodeState.ACTIVE)) {
            this.logger.warning(String.format("The Node is not ready yet, Node state %s,looking forward to the next scheduling", new Object[]{this.nodeEngine.getNode().getState()}));
            return;
        }
        IMap<Long, HashMap> metricsImap = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobMetrics");
        HashMap<TaskGroupLocation, TaskGroupContext> contextMap = new HashMap<TaskGroupLocation, TaskGroupContext>();
        contextMap.putAll(this.finishedExecutionContexts);
        contextMap.putAll(this.executionContexts);
        HashMap localMap = new HashMap();
        contextMap.forEach((taskGroupLocation, taskGroupContext) -> taskGroupContext.getTaskGroup().getTasks().forEach(task -> {
            SeaTunnelTask seaTunnelTask;
            if (task instanceof SeaTunnelTask && null != (seaTunnelTask = (SeaTunnelTask)task).getMetricsContext()) {
                localMap.put(seaTunnelTask.getTaskLocation(), seaTunnelTask.getMetricsContext());
            }
        }));
        if (localMap.size() > 0) {
            try {
                if (!metricsImap.tryLock(Constant.IMAP_RUNNING_JOB_METRICS_KEY, 2L, TimeUnit.SECONDS)) {
                    this.logger.info("try lock failed in update metrics");
                    return;
                }
                HashMap centralMap = metricsImap.computeIfAbsent(Constant.IMAP_RUNNING_JOB_METRICS_KEY, k -> new HashMap());
                centralMap.putAll(localMap);
                metricsImap.put(Constant.IMAP_RUNNING_JOB_METRICS_KEY, centralMap);
            }
            catch (Exception e) {
                this.logger.warning("The Imap acquisition failed due to the hazelcast node being offline or restarted, and will be retried next time", e);
            }
            finally {
                metricsImap.unlock(Constant.IMAP_RUNNING_JOB_METRICS_KEY);
            }
        }
        this.printTaskExecutionRuntimeInfo();
    }

    public void printTaskExecutionRuntimeInfo() {
        if (this.logger.isFineEnabled()) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executorService;
            int activeCount = threadPoolExecutor.getActiveCount();
            int taskQueueSize = this.threadShareTaskQueue.size();
            long completedTaskCount = threadPoolExecutor.getCompletedTaskCount();
            long taskCount = threadPoolExecutor.getTaskCount();
            this.logger.fine(StringFormatUtils.formatTable("TaskExecutionServer Thread Pool Status", "activeCount", activeCount, "threadShareTaskQueueSize", taskQueueSize, "completedTaskCount", completedTaskCount, "taskCount", taskCount));
        }
    }

    public final class TaskGroupExecutionTracker {
        private final TaskGroup taskGroup;
        final CompletableFuture<TaskExecutionState> future;
        volatile List<Future<?>> blockingFutures = Collections.emptyList();
        private final AtomicInteger completionLatch;
        private final AtomicReference<Throwable> executionException = new AtomicReference();
        private final AtomicBoolean isCancel = new AtomicBoolean(false);
        private Map<Long, Future<?>> currRunningTaskFuture = new ConcurrentHashMap();

        TaskGroupExecutionTracker(@NonNull CompletableFuture<Void> cancellationFuture, @NonNull TaskGroup taskGroup, CompletableFuture<TaskExecutionState> future) {
            if (cancellationFuture == null) {
                throw new NullPointerException("cancellationFuture is marked non-null but is null");
            }
            if (taskGroup == null) {
                throw new NullPointerException("taskGroup is marked non-null but is null");
            }
            if (future == null) {
                throw new NullPointerException("future is marked non-null but is null");
            }
            this.future = future;
            this.completionLatch = new AtomicInteger(taskGroup.getTasks().size());
            this.taskGroup = taskGroup;
            cancellationFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(TaskExecutionService.this.logger, (r, e) -> {
                this.isCancel.set(true);
                if (e == null) {
                    e = new IllegalStateException("cancellationFuture should be completed exceptionally");
                }
                this.exception((Throwable)e);
                this.cancelAllTask(taskGroup.getTaskGroupLocation());
            }));
        }

        void exception(Throwable t) {
            this.executionException.compareAndSet(null, t);
        }

        private void cancelAllTask(TaskGroupLocation taskGroupLocation) {
            try {
                this.blockingFutures.forEach(f -> f.cancel(true));
                this.currRunningTaskFuture.values().forEach(f -> f.cancel(true));
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            this.cancelAsyncFunction(taskGroupLocation);
        }

        private void cancelAsyncFunction(TaskGroupLocation taskGroupLocation) {
            try {
                if (TaskExecutionService.this.taskAsyncFunctionFuture.containsKey(taskGroupLocation)) {
                    ((Map)TaskExecutionService.this.taskAsyncFunctionFuture.remove(taskGroupLocation)).values().stream().filter(f -> !f.isDone()).filter(f -> !f.isCancelled()).forEach(f -> f.cancel(true));
                }
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        void taskDone(Task task) {
            TaskGroupLocation taskGroupLocation = this.taskGroup.getTaskGroupLocation();
            TaskExecutionService.this.logger.info(String.format("taskDone, taskId = %d, taskGroup = %s", task.getTaskID(), taskGroupLocation));
            Throwable ex = this.executionException.get();
            if (this.completionLatch.decrementAndGet() == 0) {
                ((TaskGroupContext)TaskExecutionService.this.executionContexts.get(taskGroupLocation)).setClassLoader(null);
                TaskExecutionService.this.finishedExecutionContexts.put(taskGroupLocation, TaskExecutionService.this.executionContexts.remove(taskGroupLocation));
                TaskExecutionService.this.cancellationFutures.remove(taskGroupLocation);
                this.cancelAsyncFunction(taskGroupLocation);
                if (ex == null) {
                    this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.FINISHED));
                    return;
                }
                if (this.isCancel.get()) {
                    this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.CANCELED));
                    return;
                }
                this.future.complete(new TaskExecutionState(taskGroupLocation, ExecutionState.FAILED, ex));
            }
            if (!this.isCancel.get() && ex != null) {
                this.cancelAllTask(taskGroupLocation);
            }
        }

        boolean executionCompletedExceptionally() {
            return this.executionException.get() != null;
        }

        public Map<Long, Future<?>> getCurrRunningTaskFuture() {
            return this.currRunningTaskFuture;
        }
    }

    public final class RunBusWorkSupplier {
        ExecutorService executorService;
        LinkedBlockingDeque<TaskTracker> taskQueue;

        public RunBusWorkSupplier(ExecutorService executorService, LinkedBlockingDeque<TaskTracker> taskqueue) {
            this.executorService = executorService;
            this.taskQueue = taskqueue;
        }

        public boolean runNewBusWork(boolean checkTaskQueue) {
            if (!checkTaskQueue || this.taskQueue.size() > 0) {
                LinkedBlockingQueue futureBlockingQueue = new LinkedBlockingQueue();
                CooperativeTaskWorker cooperativeTaskWorker = new CooperativeTaskWorker(this.taskQueue, this, futureBlockingQueue);
                Future<?> submit = this.executorService.submit(cooperativeTaskWorker);
                futureBlockingQueue.add(submit);
                return true;
            }
            return false;
        }
    }

    public final class CooperativeTaskWorker
    implements Runnable {
        AtomicBoolean keep = new AtomicBoolean(true);
        public AtomicReference<TaskTracker> exclusiveTaskTracker = new AtomicReference();
        final TaskCallTimer timer;
        private Thread myThread;
        public LinkedBlockingDeque<TaskTracker> taskqueue;
        private Future<?> thisTaskFuture;
        private BlockingQueue<Future<?>> futureBlockingQueue;

        public CooperativeTaskWorker(LinkedBlockingDeque<TaskTracker> taskqueue, RunBusWorkSupplier runBusWorkSupplier, BlockingQueue<Future<?>> futureBlockingQueue) {
            TaskExecutionService.this.logger.info(String.format("Created new BusWork : %s", this.hashCode()));
            this.taskqueue = taskqueue;
            this.timer = new TaskCallTimer(50L, this.keep, runBusWorkSupplier, this);
            this.futureBlockingQueue = futureBlockingQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.thisTaskFuture = this.futureBlockingQueue.take();
            this.futureBlockingQueue = null;
            this.myThread = Thread.currentThread();
            while (this.keep.get() && TaskExecutionService.this.isRunning) {
                ProgressState call;
                TaskGroupExecutionTracker taskGroupExecutionTracker;
                TaskTracker taskTracker;
                block18: {
                    taskTracker = null != this.exclusiveTaskTracker.get() ? this.exclusiveTaskTracker.get() : this.taskqueue.takeFirst();
                    taskGroupExecutionTracker = taskTracker.taskGroupExecutionTracker;
                    if (taskGroupExecutionTracker.executionCompletedExceptionally()) {
                        taskGroupExecutionTracker.taskDone(taskTracker.task);
                        if (null == this.exclusiveTaskTracker.get()) continue;
                        break;
                    }
                    taskGroupExecutionTracker.currRunningTaskFuture.put(taskTracker.task.getTaskID(), this.thisTaskFuture);
                    if (null == this.exclusiveTaskTracker.get()) {
                        this.timer.timerStart(taskTracker);
                    }
                    call = null;
                    try {
                        this.myThread.setContextClassLoader(((TaskGroupContext)TaskExecutionService.this.executionContexts.get(taskGroupExecutionTracker.taskGroup.getTaskGroupLocation())).getClassLoader());
                        call = taskTracker.task.call();
                        TaskCallTimer taskCallTimer = this.timer;
                        synchronized (taskCallTimer) {
                            this.timer.timerStop();
                        }
                    }
                    catch (InterruptedException e) {
                        if (taskGroupExecutionTracker.executionException.get() == null && !taskGroupExecutionTracker.isCancel.get()) {
                            taskGroupExecutionTracker.exception(e);
                        }
                        taskGroupExecutionTracker.taskDone(taskTracker.task);
                        TaskExecutionService.this.logger.warning("Exception in " + taskTracker.task, e);
                        if (null == this.exclusiveTaskTracker.get()) break block18;
                        break;
                    }
                    catch (Throwable e) {
                        taskGroupExecutionTracker.exception(e);
                        taskGroupExecutionTracker.taskDone(taskTracker.task);
                        TaskExecutionService.this.logger.warning("Exception in " + taskTracker.task, e);
                        if (null == this.exclusiveTaskTracker.get()) break block18;
                        break;
                    }
                    finally {
                        this.timer.timerStop();
                        taskGroupExecutionTracker.currRunningTaskFuture.remove(taskTracker.task.getTaskID());
                    }
                }
                if (null == call) continue;
                if (call.isDone()) {
                    taskGroupExecutionTracker.taskDone(taskTracker.task);
                    if (null == this.exclusiveTaskTracker.get()) continue;
                    break;
                }
                if (null != this.exclusiveTaskTracker.get()) continue;
                this.taskqueue.offer(taskTracker);
            }
        }
    }

    private final class BlockingTaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger seq = new AtomicInteger();

        private BlockingTaskThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            if (r == null) {
                throw new NullPointerException("r is marked non-null but is null");
            }
            return new Thread(r, String.format("hz.%s.seaTunnel.task.thread-%d", TaskExecutionService.this.hzInstanceName, this.seq.getAndIncrement()));
        }
    }

    private final class BlockingWorker
    implements Runnable {
        private final TaskTracker tracker;
        private final CountDownLatch startedLatch;

        private BlockingWorker(TaskTracker tracker, CountDownLatch startedLatch) {
            this.tracker = tracker;
            this.startedLatch = startedLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskGroupExecutionTracker taskGroupExecutionTracker = this.tracker.taskGroupExecutionTracker;
            ClassLoader classLoader = ((TaskGroupContext)TaskExecutionService.this.executionContexts.get(taskGroupExecutionTracker.taskGroup.getTaskGroupLocation())).getClassLoader();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Task t = this.tracker.task;
            try {
                ProgressState result2;
                this.startedLatch.countDown();
                t.init();
                while (!(result2 = t.call()).isDone() && TaskExecutionService.this.isRunning && !taskGroupExecutionTracker.executionCompletedExceptionally()) {
                }
            }
            catch (InterruptedException e) {
                TaskExecutionService.this.logger.warning(String.format("Interrupted task %d - %s", t.getTaskID(), t));
                if (taskGroupExecutionTracker.executionException.get() == null && !taskGroupExecutionTracker.isCancel.get()) {
                    taskGroupExecutionTracker.exception(e);
                }
            }
            catch (Throwable e) {
                TaskExecutionService.this.logger.warning("Exception in " + t, e);
                taskGroupExecutionTracker.exception(e);
            }
            finally {
                taskGroupExecutionTracker.taskDone(t);
                try {
                    this.tracker.task.close();
                }
                catch (IOException e) {
                    TaskExecutionService.this.logger.severe("Close task error", e);
                }
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

