/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.spi.annotation.Beta;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface GenericRecordBuilder {
    @Nonnull
    public static GenericRecordBuilder portable(@Nonnull ClassDefinition classDefinition) {
        return new PortableGenericRecordBuilder(classDefinition);
    }

    @Beta
    @Nonnull
    public static GenericRecordBuilder compact(String typeName) {
        return new DeserializedGenericRecordBuilder(typeName);
    }

    @Nonnull
    public GenericRecord build();

    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String var1, boolean var2);

    @Nonnull
    public GenericRecordBuilder setInt8(@Nonnull String var1, byte var2);

    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String var1, char var2);

    @Nonnull
    public GenericRecordBuilder setInt16(@Nonnull String var1, short var2);

    @Nonnull
    public GenericRecordBuilder setInt32(@Nonnull String var1, int var2);

    @Nonnull
    public GenericRecordBuilder setInt64(@Nonnull String var1, long var2);

    @Nonnull
    public GenericRecordBuilder setFloat32(@Nonnull String var1, float var2);

    @Nonnull
    public GenericRecordBuilder setFloat64(@Nonnull String var1, double var2);

    @Nonnull
    public GenericRecordBuilder setNullableBoolean(@Nonnull String var1, @Nullable Boolean var2);

    @Nonnull
    public GenericRecordBuilder setNullableInt8(@Nonnull String var1, @Nullable Byte var2);

    @Nonnull
    public GenericRecordBuilder setNullableInt16(@Nonnull String var1, @Nullable Short var2);

    @Nonnull
    public GenericRecordBuilder setNullableInt32(@Nonnull String var1, @Nullable Integer var2);

    @Nonnull
    public GenericRecordBuilder setNullableInt64(@Nonnull String var1, @Nullable Long var2);

    @Nonnull
    public GenericRecordBuilder setNullableFloat32(@Nonnull String var1, @Nullable Float var2);

    @Nonnull
    public GenericRecordBuilder setNullableFloat64(@Nonnull String var1, @Nullable Double var2);

    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String var1, @Nullable String var2);

    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String var1, @Nullable GenericRecord var2);

    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String var1, @Nullable BigDecimal var2);

    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String var1, @Nullable LocalTime var2);

    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String var1, @Nullable LocalDate var2);

    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String var1, @Nullable LocalDateTime var2);

    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String var1, @Nullable OffsetDateTime var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfBoolean(@Nonnull String var1, @Nullable boolean[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfInt8(@Nonnull String var1, @Nullable byte[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfChar(@Nonnull String var1, @Nullable char[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfInt16(@Nonnull String var1, @Nullable short[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfInt32(@Nonnull String var1, @Nullable int[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfInt64(@Nonnull String var1, @Nullable long[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfFloat32(@Nonnull String var1, @Nullable float[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfFloat64(@Nonnull String var1, @Nullable double[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableBoolean(@Nonnull String var1, @Nullable Boolean[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt8(@Nonnull String var1, @Nullable Byte[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt16(@Nonnull String var1, @Nullable Short[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt32(@Nonnull String var1, @Nullable Integer[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableInt64(@Nonnull String var1, @Nullable Long[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat32(@Nonnull String var1, @Nullable Float[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfNullableFloat64(@Nonnull String var1, @Nullable Double[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfString(@Nonnull String var1, @Nullable String[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfDecimal(@Nonnull String var1, @Nullable BigDecimal[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfTime(@Nonnull String var1, @Nullable LocalTime[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfDate(@Nonnull String var1, @Nullable LocalDate[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfTimestamp(@Nonnull String var1, @Nullable LocalDateTime[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfTimestampWithTimezone(@Nonnull String var1, @Nullable OffsetDateTime[] var2);

    @Nonnull
    public GenericRecordBuilder setArrayOfGenericRecord(@Nonnull String var1, @Nullable GenericRecord[] var2);
}

